package ru.yandex.partner.jsonapi.models;

import ru.yandex.direct.model.Model;
import ru.yandex.direct.model.ModelChanges;
import ru.yandex.direct.model.ModelWithId;
import ru.yandex.partner.jsonapi.crnk.fields.ApiField;
import ru.yandex.partner.jsonapi.crnk.fields.ApiFieldsService;
import ru.yandex.partner.jsonapi.crnk.fields.IncomingApiFields;
import ru.yandex.partner.jsonapi.crnk.fields.ModelPath;
import ru.yandex.partner.jsonapi.crnk.fields.ModelPathForApi;

public class SimpleDirtyChecking<M extends ModelWithId> implements DirtyChecking<M> {
    private final ApiFieldsService<M> apiFieldsService;
    private final ApiModel<M> apiModel;

    public SimpleDirtyChecking(
            ApiFieldsService<M> apiFieldsService,
            ApiModel<M> apiModel
    ) {
        this.apiFieldsService = apiFieldsService;
        this.apiModel = apiModel;
    }

    @SuppressWarnings({"rawtypes", "unchecked"})
    @Override
    public ModelChanges<M> generateModelChanges(M modelFromDb, M modelFromApi, IncomingApiFields<M> updatedFields) {
        ModelChanges<M> modelChanges = new ModelChanges<>(modelFromDb.getId(), apiModel.getModelClass());

        // обычные поля
        updatedFields.values().stream()
                .map(ApiField::getModelPath)
                .map(modelPath -> (ModelPathForApi) modelPath)
                .filter(modelPath -> !modelPath.isNested())
                .forEach(modelPath -> modelChanges.process(
                        modelPath.get(modelFromApi),
                        modelPath.rootProperty()
                ));

        // nested поля
        updatedFields.values().stream()
                .map(ApiField::getModelPath)
                .map(modelPath -> (ModelPathForApi) modelPath)
                .filter(ModelPathForApi::isNested)
                .distinct()
                .forEach(modelPath -> {
                    // получили вложенное значение с частичным заполнением (например strategy)
                    Model nestedModelFromApi = (Model) modelPath.rootProperty().get(modelFromApi);

                    // Выбираем modelPath, которые есть в sourceModel, но которые не изменялись (не входят в fields)
                    apiFieldsService.getApiFields().stream()
                            .filter(mApiField -> mApiField.getModelPath() != null)
                            .filter(mApiField -> modelPath.rootProperty()
                                    .equals(mApiField.getModelPath().rootProperty()))
                            .filter(mApiField -> !updatedFields.containsKey(mApiField.getJsonName()))
                            .map(ApiField::getModelPath)
                            .map(modelPath1 -> (ModelPath) modelPath1)
                            .forEach(modelPath1 -> {
                                Object o = modelPath1.get(modelFromDb);
                                modelPath1.set(modelFromApi, o);
                            });

                    modelChanges.process(nestedModelFromApi, modelPath.rootProperty());
                });

        return modelChanges;
    }
}
