package ru.yandex.partner.jsonapi.models.actions;

import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.direct.model.ModelWithId;
import ru.yandex.partner.core.action.factories.ActionFactory;
import ru.yandex.partner.core.action.factories.CustomPayloadActionFactory;
import ru.yandex.partner.core.action.factories.ModelPayloadActionFactory;

@ParametersAreNonnullByDefault
public interface ActionService<M extends ModelWithId> {

    @Nullable
    ActionFactory<M, ?> getFactory(String actionName);

    @Nullable
    String getCoreActionName(String apiActionName);

    ModelPayloadActionFactory<M, ?> getModelPayloadActionFactory(String actionName);

    CustomPayloadActionFactory<M, ?> getCustomPayloadFactory(String actionName);
}
