package ru.yandex.partner.jsonapi.models.block;

import java.util.EnumMap;

import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.partner.core.entity.block.model.BaseBlock;
import ru.yandex.partner.jsonapi.crnk.fields.ApiFieldsAccessRulesFunction;
import ru.yandex.partner.jsonapi.crnk.fields.EditableData;
import ru.yandex.partner.jsonapi.models.CommonFunctionComposite;
import ru.yandex.partner.jsonapi.models.FunctionNameEnum;
import ru.yandex.partner.jsonapi.models.block.parts.GodModeAvailable;

import static ru.yandex.partner.jsonapi.models.FunctionNameEnum.GOD_MODE_FUNCTION;

@ParametersAreNonnullByDefault
public abstract class AbstractBlockAccessFunctionComposite<B extends BaseBlock>
        extends CommonFunctionComposite<B>
        implements GodModeAvailable<B> {

    @Override
    protected void initMap(
            EnumMap<FunctionNameEnum, ApiFieldsAccessRulesFunction<B>> availableFunctions,
            EnumMap<FunctionNameEnum, ApiFieldsAccessRulesFunction<EditableData<B>>> editableFunctions) {
        editableFunctions.put(GOD_MODE_FUNCTION, isGodModeEditableFunction());
    }
}
