package ru.yandex.partner.jsonapi.models.block;

import java.util.EnumMap;
import java.util.List;

import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.partner.core.entity.block.model.BaseBlock;
import ru.yandex.partner.core.entity.block.model.prop.BlockWithAdfoxAdfoxBlockPropHolder;
import ru.yandex.partner.core.entity.block.model.prop.BlockWithCustomBkDataFlagIsCustomBkDataPropHolder;
import ru.yandex.partner.jsonapi.crnk.fields.ApiFieldsAccessRulesFunction;
import ru.yandex.partner.jsonapi.crnk.fields.EditableData;
import ru.yandex.partner.jsonapi.models.FunctionNameEnum;
import ru.yandex.partner.jsonapi.models.block.access.NotCustomBkDataAccessRuleFunction;

import static ru.yandex.partner.jsonapi.models.FunctionNameEnum.GOD_MODE_AND_NON_ADFOX_BLOCK;
import static ru.yandex.partner.jsonapi.models.FunctionNameEnum.NON_ADFOX_BLOCK;

@ParametersAreNonnullByDefault
public class BlockAccessFunctionComposite<
        B extends BaseBlock
                & BlockWithAdfoxAdfoxBlockPropHolder
                & BlockWithCustomBkDataFlagIsCustomBkDataPropHolder>
        extends AbstractBlockAccessFunctionComposite<B> {

    @Override
    protected void initMap(
            EnumMap<FunctionNameEnum, ApiFieldsAccessRulesFunction<B>> availableFunctions,
            EnumMap<FunctionNameEnum, ApiFieldsAccessRulesFunction<EditableData<B>>> editableFunctions) {
        super.initMap(availableFunctions, editableFunctions);
        availableFunctions.put(NON_ADFOX_BLOCK, nonAdfoxBlockAvailableFunction());
        editableFunctions.put(GOD_MODE_AND_NON_ADFOX_BLOCK, ApiFieldsAccessRulesFunction.and(List.of(
                isGodModeEditableFunction(),
                nonAdfoxBlockEditableFunction())));
    }

    @Override
    public ApiFieldsAccessRulesFunction<B> isGodModeFunction() {
        return new NotCustomBkDataAccessRuleFunction<>();
    }

    private ApiFieldsAccessRulesFunction<B> nonAdfoxBlockAvailableFunction() {
        return new ApiFieldsAccessRulesFunction<>(
                (userAuthentication, block) -> !Boolean.TRUE.equals(block.getAdfoxBlock()),
                BlockWithAdfoxAdfoxBlockPropHolder.ADFOX_BLOCK);
    }

    private ApiFieldsAccessRulesFunction<EditableData<B>> nonAdfoxBlockEditableFunction() {
        var available = nonAdfoxBlockAvailableFunction();
        return new ApiFieldsAccessRulesFunction<>(
                (userAuthentication, bEditableModelData) -> available.getAccessRuleFunction().apply(
                        userAuthentication,
                        bEditableModelData.getPatchedOrElseActual()
                ),
                available.getRequiredProperties()
        );
    }

}
