package ru.yandex.partner.jsonapi.models.block;

import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;

import ru.yandex.partner.core.entity.block.model.BlockWithDesignTemplates;
import ru.yandex.partner.core.entity.user.model.User;
import ru.yandex.partner.dbschema.partner.enums.DesignTemplatesType;
import ru.yandex.partner.jsonapi.crnk.block.BlockCrnkJsonFieldAliases;
import ru.yandex.partner.jsonapi.crnk.fields.ForeignFieldDefaultsService;
import ru.yandex.partner.jsonapi.crnk.fields.QueryParamsContext;

import static ru.yandex.partner.core.entity.block.type.designtemplates.BlockWithDesignTemplatesAndDependsFieldsValidatorProvider.getAvailableDesignTemplateTypes;

public abstract class BlockDesignTemplateTypesDefaultsService<B extends BlockWithDesignTemplates>
        implements ForeignFieldDefaultsService<B> {

    public String getJsonName() {
        return BlockCrnkJsonFieldAliases.AVAILABLE_DESIGN_TEMPLATE_TYPES;
    }

    @Override
    public Map<String, Object> getDefaults(QueryParamsContext<B> context) {
        B block = context.getModelFromAttributes();

        User owner = getOwner(block);
        Set<String> featuresAndOptions = new HashSet<>(owner.getFeatures());

        String siteVersion = Optional.ofNullable(getSiteVersion(block))
                .orElse("");

        Set<DesignTemplatesType> types = getAvailableDesignTemplateTypes(
                siteVersion, featuresAndOptions, getShowVideo(block)
        );

        return Map.of(
                BlockCrnkJsonFieldAliases.AVAILABLE_DESIGN_TEMPLATE_TYPES,
                types.stream().map(DesignTemplatesType::getLiteral).collect(Collectors.toList())
        );
    }

    protected abstract String getSiteVersion(B block);

    protected abstract Boolean getShowVideo(B block);

    protected abstract User getOwner(B block);
}
