package ru.yandex.partner.jsonapi.models.block;

import ru.yandex.partner.libs.auth.RightHolder;

public enum BlockRightNames implements RightHolder {
    VIEW("%s_view"),
    VIEW_ALL("%s_view_all"),
    VIEW_ZERO_BLOCK("%s_view_zero_block"),
    VIEW_TECHNICAL_RTB_BLOCK("%s_view_technical_rtb_block"),
    VIEW_FIELD__COMMENT("%s_view_field__comment"),
    VIEW_FIELD__BLIND("%s_view_field__blind"),
    VIEW_FIELD__IS_TUTBY("%s_view_field__is_tutby"),
    VIEW_FIELD__BANNER_DESCRIPTION("%s_view_field__banner_description"),
    VIEW_FIELD__SHOW_VIDEO("%s_view_field__show_video"),
    VIEW_FIELD__DSPS("%s_view_field__dsps"),
    VIEW_FIELD__ALL_UNMODERATED_DSPS("%s_view_field__all_unmoderated_dsps"),
    VIEW_FIELD__UNMODERATED_DSPS("%s_view_field__unmoderated_dsps"),
    VIEW_FIELD__ORDER_TAGS("%s_view_field__order_tags"),
    VIEW_FIELD__TARGET_TAGS("%s_view_field__target_tags"),
    VIEW_FIELD__BK_DATA("%s_view_field__bk_data"),
    VIEW_FIELD__MAX_DURATION("%s_view_field__max_duration"),
    VIEW_FIELD__ONLY_PORTAL_TRUSTED_BANNERS("%s_view_field__only_portal_trusted_banners"),
    VIEW_FIELD__CUSTOM_BK_OPTIONS("%s_view_field__custom_bk_options"),
    VIEW_FIELD__CLOSE_BUTTON_DELAY("%s_view_field__close_button_delay"),
    VIEW_FIELD__PLACE_ID("%s_view_field__place_id"),
    VIEW_FIELD__MOBILE_APP_MODE("%s_view_field__mobile_app_mode"),
    VIEW_FIELD__DSP_BLOCKS("%s_view_field__dsp_blocks"),

    EDIT("%s_edit"),
    EDIT_ALL("%s_edit_all"),
    EDIT_FIELD__BK_DATA("%s_edit_field__bk_data"),
    EDIT_FIELD__BLIND("%s_edit_field__blind"),
    EDIT_FIELD__DSPS("%s_edit_field__dsps"),
    EDIT_FIELD__COMMENT("%s_edit_field__comment"),
    EDIT_FIELD__MAX_DURATION("%s_edit_field__max_duration"),
    EDIT_FIELD__READONLY("%s_edit_field__readonly"),
    EDIT_FIELD__SHOW_VIDEO("%s_edit_field__show_video"),
    EDIT_FIELD__SITE_VERSION("%s_edit_field__site_version"),
    EDIT_FIELD_STRATEGY("%s_edit_field__strategy"),
    EDIT_FIELD__TARGET_TAGS("%s_edit_field__target_tags"),
    EDIT_FIELD__ONLY_PORTAL_TRUSTED_BANNERS("%s_edit_field__only_portal_trusted_banners"),
    EDIT_FIELD__ORDER_TAGS("%s_edit_field__order_tags"),
    EDIT_FIELD__UNMODERATED_DSPS("%s_edit_field__unmoderated_dsps"),
    EDIT_FIELD__CUSTOM_BK_OPTIONS("%s_edit_field__custom_bk_options"),
    EDIT_FIELD__PICATEGORIES("%s_edit_field__picategories"),
    EDIT_FIELD__GEO("%s_edit_field__geo"),
    EDIT_FIELD__CLOSE_BUTTON_DELAY("%s_edit_field__close_button_delay"),
    EDIT_FIELD__PLACE_ID("%s_edit_field__place_id"),
    EDIT_FIELD__RICH_MEDIA("%s_edit_field__rich_media"),
    EDIT_FIELD__IS_EXTERNAL_MEDIATION("%s_edit_field__is_external_mediation"),
    EDIT_FIELD__IS_BIDDING("%s_edit_field__is_bidding"),
    EDIT_FIELD__IS_MOBILE_MEDIATION("%s_edit_field__is_mobile_mediation"),
    EDIT_FIELD__MOBILE_APP_MODE("%s_edit_field__mobile_app_mode"),
    EDIT_FIELD__DSP_BLOCKS("%s_edit_field__dsp_blocks"),
    EDIT_FIELD__IS_CUSTOM_FORMAT_DIRECT("%s_edit_field__is_custom_format_direct"),

    ADD("do_%s_add"),

    ADD_FIELD_IS_MOBILE_MEDIATION("%s_add_field__is_mobile_mediation"),
    CAN_EDIT_MOBILE_MEDIATION("can_edit_mobile_mediation");


    private final String shortRightName;

    BlockRightNames(String shortRightName) {
        this.shortRightName = shortRightName;
    }

    @Override
    public String getRightName() {
        return shortRightName;
    }

    @Override
    public String getFullRightName(String modelName) {
        return String.format(shortRightName, modelName);
    }
}
