package ru.yandex.partner.jsonapi.models.block;

import java.util.EnumMap;

import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.partner.core.entity.block.model.BaseBlock;
import ru.yandex.partner.core.entity.block.model.prop.BlockWithCustomBkDataFlagIsCustomBkDataPropHolder;
import ru.yandex.partner.jsonapi.crnk.fields.ApiFieldsAccessRulesFunction;
import ru.yandex.partner.jsonapi.crnk.fields.EditableData;
import ru.yandex.partner.jsonapi.models.FunctionNameEnum;
import ru.yandex.partner.jsonapi.models.block.access.NotCustomBkDataAccessRuleFunction;

@ParametersAreNonnullByDefault
public class BlockWithoutAdfoxAccessFunctionComposite<
        B extends BaseBlock
                & BlockWithCustomBkDataFlagIsCustomBkDataPropHolder>
        extends AbstractBlockAccessFunctionComposite<B> {
    //TODO

    @Override
    protected void initMap(
            EnumMap<FunctionNameEnum, ApiFieldsAccessRulesFunction<B>> availableFunctions,
            EnumMap<FunctionNameEnum, ApiFieldsAccessRulesFunction<EditableData<B>>> editableFunctions) {
        super.initMap(availableFunctions, editableFunctions);
    }

    @Override
    public ApiFieldsAccessRulesFunction<B> isGodModeFunction() {
        return new NotCustomBkDataAccessRuleFunction<>();
    }


}
