package ru.yandex.partner.jsonapi.models.block.parts;

import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

import ru.yandex.partner.core.entity.block.filter.BlockFilters;
import ru.yandex.partner.core.entity.block.model.BlockWithAdfox;
import ru.yandex.partner.jsonapi.crnk.block.BlockCrnkJsonFieldAliases;
import ru.yandex.partner.jsonapi.crnk.fields.ApiField;
import ru.yandex.partner.jsonapi.crnk.fields.ApiFieldsAccessRulesFunction;
import ru.yandex.partner.jsonapi.crnk.filter.CrnkFilter;
import ru.yandex.partner.jsonapi.messages.block.RtbMsg;
import ru.yandex.partner.jsonapi.models.ApiModelPart;
import ru.yandex.partner.jsonapi.models.block.BlockFilterNameEnum;

import static ru.yandex.partner.jsonapi.crnk.fields.ApiFieldsAccessRules.checkable;

public class ApiAdfoxBlockModelPart<B extends BlockWithAdfox> implements ApiModelPart<B> {
    @Override
    public List<ApiField<B>> getFields() {
        ApiField<B> adfoxBlock = ApiField
                .<B, Boolean>convertibleApiField(Boolean.class, B.ADFOX_BLOCK)
                .withAvailableFunction(checkable(new ApiFieldsAccessRulesFunction<>(
                        (userAuthentication, block) -> Boolean.TRUE.equals(block.getAdfoxBlock()),
                        B.ADFOX_BLOCK)))
                .withAlwaysPermitAddFieldFunction()
                .build(BlockCrnkJsonFieldAliases.ADFOX_BLOCK);

        return List.of(
                adfoxBlock
        );
    }

    @Override
    public Map<String, CrnkFilter<B, ?>> getFilters() {
        var list = List.<CrnkFilter<B, ?>>of(
                CrnkFilter.builder(BlockFilterNameEnum.ADFOX_BLOCK)
                        .setLabel(RtbMsg.ADFOX_BLOCK)
                        .setExposed(() -> true)
                        .toCrnkFilter(BlockFilters.ADFOX_BLOCK)
        );

        return list.stream()
                .collect(Collectors.toMap(
                        CrnkFilter::getName,
                        baseBlockCrnkFilter -> baseBlockCrnkFilter
                ));
    }
}
