package ru.yandex.partner.jsonapi.models.block.parts;

import java.util.List;

import ru.yandex.partner.core.entity.block.model.BlockWithAltSize;
import ru.yandex.partner.jsonapi.crnk.block.BlockCrnkJsonFieldAliases;
import ru.yandex.partner.jsonapi.crnk.fields.ApiField;
import ru.yandex.partner.jsonapi.models.ApiModelPart;

import static ru.yandex.partner.jsonapi.crnk.fields.ApiFieldsAccessRules.namedFunction;
import static ru.yandex.partner.jsonapi.crnk.fields.ApiFieldsAccessRules.sameAs;
import static ru.yandex.partner.jsonapi.models.FunctionNameEnum.GOD_MODE_AND_NON_ADFOX_BLOCK;
import static ru.yandex.partner.jsonapi.models.FunctionNameEnum.NON_ADFOX_BLOCK;

public class ApiAltSizeModelPart<B extends BlockWithAltSize> implements ApiModelPart<B> {

    @Override
    public List<ApiField<B>> getFields() {
        var altHeight = ApiField
                .<B, Long>convertibleApiField(Long.class, B.ALT_HEIGHT)
                .withAvailableFunction(namedFunction(NON_ADFOX_BLOCK))
                .withEditableFunction(namedFunction(GOD_MODE_AND_NON_ADFOX_BLOCK))
                .withAddFieldLikeEditableFunction()
                .build(BlockCrnkJsonFieldAliases.ALT_HEIGHT);
        return List.of(
                altHeight,
                ApiField
                        .<B, Long>convertibleApiField(Long.class, B.ALT_WIDTH)
                        .withAvailableFunction(sameAs(altHeight))
                        .withEditableFunction(sameAs(altHeight))
                        .withAddFieldLikeEditableFunction()
                        .build(BlockCrnkJsonFieldAliases.ALT_WIDTH)
        );
    }
}
