package ru.yandex.partner.jsonapi.models.block.parts;

import java.util.List;

import ru.yandex.partner.core.entity.block.model.BlockWithAlternativeCode;
import ru.yandex.partner.jsonapi.crnk.block.BlockCrnkJsonFieldAliases;
import ru.yandex.partner.jsonapi.crnk.fields.ApiField;
import ru.yandex.partner.jsonapi.models.ApiModelPart;

import static ru.yandex.partner.jsonapi.crnk.fields.ApiFieldsAccessRules.namedFunction;
import static ru.yandex.partner.jsonapi.models.FunctionNameEnum.GOD_MODE_AND_NON_ADFOX_BLOCK;
import static ru.yandex.partner.jsonapi.models.FunctionNameEnum.NON_ADFOX_BLOCK;

public class ApiAlternativeCodeModelPart<B extends BlockWithAlternativeCode> implements ApiModelPart<B> {

    @Override
    public List<ApiField<B>> getFields() {
        return List.of(
                ApiField.<B, String>convertibleApiField(String.class, B.ALTERNATIVE_CODE)
                        .withAvailableFunction(namedFunction(NON_ADFOX_BLOCK))
                        .withEditableFunction(namedFunction(GOD_MODE_AND_NON_ADFOX_BLOCK))
                        .withAddFieldLikeEditableFunction()
                        .build(BlockCrnkJsonFieldAliases.ALTERNATIVE_CODE)
        );
    }
}
