package ru.yandex.partner.jsonapi.models.block.parts;

import java.util.List;

import ru.yandex.partner.core.entity.block.model.BlockWithRtbFields;
import ru.yandex.partner.jsonapi.crnk.block.BlockCrnkJsonFieldAliases;
import ru.yandex.partner.jsonapi.crnk.fields.ApiField;
import ru.yandex.partner.jsonapi.models.AbstractApiModelPart;
import ru.yandex.partner.jsonapi.models.block.access.HasRightAccessRuleFunction;

import static ru.yandex.partner.jsonapi.crnk.fields.ApiFieldsAccessRules.checkableByRight;
import static ru.yandex.partner.jsonapi.crnk.fields.ApiFieldsAccessRulesFunction.checkableAnd;
import static ru.yandex.partner.jsonapi.models.block.BlockRightNames.EDIT_FIELD__BLIND;

public abstract class ApiBlindModelPart<B extends BlockWithRtbFields>
        extends AbstractApiModelPart<B> implements GodModeAvailable<B> {

    public ApiBlindModelPart(String modelName) {
        super(modelName);
    }

    @Override
    public List<ApiField<B>> getFields() {
        return List.of(ApiField
                .<B, Long>convertibleApiField(Long.class, B.BLIND)
                .withEditableFunction(checkableAnd(List.of(
                        new HasRightAccessRuleFunction<>(EDIT_FIELD__BLIND.getFullRightName(getModelName())),
                        isGodModeEditableFunction())))
                .withAddFieldFunction(checkableByRight(EDIT_FIELD__BLIND.getFullRightName(getModelName())))
                .build(BlockCrnkJsonFieldAliases.BLIND)
        );
    }
}
