package ru.yandex.partner.jsonapi.models.block.parts;

import java.util.List;

import ru.yandex.partner.core.entity.block.model.BlockWithBrands;
import ru.yandex.partner.core.entity.block.model.Brand;
import ru.yandex.partner.jsonapi.crnk.block.BlockCrnkJsonFieldAliases;
import ru.yandex.partner.jsonapi.crnk.fields.ApiField;
import ru.yandex.partner.jsonapi.models.ApiModelPart;
import ru.yandex.partner.jsonapi.models.ModelClassUtils;

import static ru.yandex.partner.jsonapi.crnk.fields.ApiFieldsAccessRules.namedFunction;
import static ru.yandex.partner.jsonapi.models.FunctionNameEnum.GOD_MODE_FUNCTION;


public class ApiBrandsModelPart<B extends BlockWithBrands> implements ApiModelPart<B> {

    @Override
    public List<ApiField<B>> getFields() {
        return List.of(
                ApiField
                        .<B, List<Brand>>convertibleApiField(ModelClassUtils.getListClass(Brand.class), B.BRANDS)
                        .withEditableFunction(namedFunction(GOD_MODE_FUNCTION))
                        .withAlwaysPermitAddFieldFunction()
                        .build(BlockCrnkJsonFieldAliases.BRANDS),
                ApiField
                        .<B, Boolean>convertibleApiField(Boolean.class, B.HAS_BRANDS_SETTINGS)
                        .build(BlockCrnkJsonFieldAliases.HAS_BRANDS_SETTINGS)
        );
    }
}
