package ru.yandex.partner.jsonapi.models.block.parts;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.Function;

import ru.yandex.partner.core.entity.block.model.BlockWithCommonShowVideo;
import ru.yandex.partner.jsonapi.crnk.block.BlockCrnkJsonFieldAliases;
import ru.yandex.partner.jsonapi.crnk.fields.ApiField;
import ru.yandex.partner.jsonapi.crnk.fields.ApiFieldsAccessRulesFunction;
import ru.yandex.partner.jsonapi.crnk.fields.EditableData;
import ru.yandex.partner.jsonapi.crnk.fields.QueryParamsContext;
import ru.yandex.partner.jsonapi.models.AbstractApiModelPart;
import ru.yandex.partner.jsonapi.models.block.access.HasRightAccessRuleFunction;

import static ru.yandex.partner.jsonapi.crnk.fields.ApiFieldsAccessRules.checkable;
import static ru.yandex.partner.jsonapi.crnk.fields.ApiFieldsAccessRulesFunction.checkableAnd;
import static ru.yandex.partner.jsonapi.models.block.BlockRightNames.EDIT_FIELD__SHOW_VIDEO;

public abstract class ApiCommonShowVideoModelPart<B extends BlockWithCommonShowVideo>
        extends AbstractApiModelPart<B> implements GodModeAvailable<B>, ShowVideoAvailable<B> {

    public ApiCommonShowVideoModelPart(String modelName) {
        super(modelName);
    }

    @Override
    public List<ApiField<B>> getFields() {
        return List.of(
                ApiField
                        .<B, Boolean>convertibleApiField(Boolean.class, B.SHOW_VIDEO)
                        .withAvailableFunction(checkable(showVideoAvailableFunction()))
                        .withEditableFunction(checkableAnd(List.of(
                                getEditableRightAccessFunction(),
                                isGodModeEditableFunction(),
                                showVideoEditableFunction()
                        )))
                        .withAddFieldFunction(checkableAnd(List.of(
                                getAddfieldRightAccessFunction(),
                                isShowVideoApplicableFunction()
                        )))
                        .withDefaultsFunction(getShowVideoDefaultsFunction())
                        .build(BlockCrnkJsonFieldAliases.SHOW_VIDEO)
        );
    }

    protected ApiFieldsAccessRulesFunction<EditableData<B>> getEditableRightAccessFunction() {
        return new HasRightAccessRuleFunction<>(EDIT_FIELD__SHOW_VIDEO.getFullRightName(getModelName()));
    }

    protected ApiFieldsAccessRulesFunction<EditableData<B>> getAddfieldRightAccessFunction() {
        return new HasRightAccessRuleFunction<>(EDIT_FIELD__SHOW_VIDEO.getFullRightName(getModelName()));
    }

    protected Function<QueryParamsContext<B>, Map<String, Object>> getShowVideoDefaultsFunction() {
        return context -> {
            var userAuthentication = context.getUserAuthentication();
            B block = context.getModelFromAttributes();
            List<Integer> result = new ArrayList<>(2);
            result.add(0);
            if (isShowVideo(getModelName(), userAuthentication, block, null)) {
                result.add(1);
            }
            return Map.of(BlockCrnkJsonFieldAliases.SHOW_VIDEO, result);
        };
    }
}
