package ru.yandex.partner.jsonapi.models.block.parts;

import org.jetbrains.annotations.Nullable;

import ru.yandex.partner.core.entity.block.model.BlockWithCommonShowVideo;
import ru.yandex.partner.jsonapi.crnk.fields.ApiFieldsAccessRulesFunction;
import ru.yandex.partner.jsonapi.crnk.fields.EditableData;
import ru.yandex.partner.libs.auth.model.UserAuthentication;

public class ApiCommonShowVideoWithDelegateModelPart<B extends BlockWithCommonShowVideo>
        extends ApiCommonShowVideoModelPart<B> {

    private final ShowVideoAvailable<B> showVideoAvailableDelegate;
    private final GodModeAvailable<B> godModeAvailableDelegate;

    public ApiCommonShowVideoWithDelegateModelPart(String modelName,
                                                   ShowVideoAvailable<B> showVideoAvailableDelegate,
                                                   GodModeAvailable<B> godModeAvailableDelegate) {
        super(modelName);
        this.showVideoAvailableDelegate = showVideoAvailableDelegate;
        this.godModeAvailableDelegate = godModeAvailableDelegate;
    }

    @Override
    public ApiFieldsAccessRulesFunction<B> isGodModeFunction() {
        return godModeAvailableDelegate.isGodModeFunction();
    }

    @Override
    public ApiFieldsAccessRulesFunction<B> showVideoAvailableFunction() {
        return showVideoAvailableDelegate.showVideoAvailableFunction();
    }

    @Override
    public ApiFieldsAccessRulesFunction<EditableData<B>> showVideoEditableFunction() {
        return showVideoAvailableDelegate.showVideoEditableFunction();
    }

    @Override
    public ApiFieldsAccessRulesFunction<EditableData<B>> showVideoAddFunction() {
        return showVideoAvailableDelegate.showVideoAddFunction();
    }

    @Override
    public ApiFieldsAccessRulesFunction<EditableData<B>> isShowVideoApplicableFunction() {
        return showVideoAvailableDelegate.isShowVideoApplicableFunction();
    }

    @Override
    public boolean isShowVideo(String modelName, UserAuthentication userAuthentication, B actual, @Nullable B patched) {
        return showVideoAvailableDelegate.isShowVideo(modelName, userAuthentication, actual, patched);
    }

    @Override
    public boolean isShowVideoApplicable(String modelName, UserAuthentication userAuthentication, B block) {
        return showVideoAvailableDelegate.isShowVideoApplicable(modelName, userAuthentication, block);
    }

    @Override
    public boolean getDefaultShowVideoValue(B block) {
        return showVideoAvailableDelegate.getDefaultShowVideoValue(block);
    }
}
