package ru.yandex.partner.jsonapi.models.block.parts;

import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

import ru.yandex.partner.core.entity.block.model.BlockWithCommonShowVideoAndStrategy;
import ru.yandex.partner.core.entity.block.type.commonshowvideo.ShowVideoApplicableService;
import ru.yandex.partner.core.entity.strategy.StrategyDefaultsFieldsService;
import ru.yandex.partner.jsonapi.crnk.block.BlockCrnkJsonFieldAliases;
import ru.yandex.partner.jsonapi.crnk.fields.QueryParamsContext;
import ru.yandex.partner.jsonapi.validation.CovariantPathNodeConverterProvider;

public abstract class ApiContextRtbStrategyModelPart<B extends
        BlockWithCommonShowVideoAndStrategy>
        extends ApiStrategyWithDelegateModelPart<B> {
    private final StrategyDefaultsFieldsService strategyDefaultsFieldsService;
    private final ShowVideoApplicableService showVideoApplicableService;

    public ApiContextRtbStrategyModelPart(String modelName,
                                          ShowVideoAvailable<B> showVideoAvailableDelegate,
                                          GodModeAvailable<B> godModeAvailableDelegate,
                                          StrategyDefaultsFieldsService strategyDefaultsFieldsService,
                                          ShowVideoApplicableService showVideoApplicableService) {
        super(modelName, showVideoAvailableDelegate, godModeAvailableDelegate);
        this.strategyDefaultsFieldsService = strategyDefaultsFieldsService;
        this.showVideoApplicableService = showVideoApplicableService;
    }

    @Override
    protected Function<QueryParamsContext<B>, Map<String, Object>> getDefaultsFunction() {
        return context -> {
            if (converterProvider == null) {
                var builder = new CovariantPathNodeConverterProvider.Builder();
                this.configurePathNodeConverter(builder);
                converterProvider = builder.build();
            }
            B block = context.getModelFromAttributes();
            return Map.of(
                    BlockCrnkJsonFieldAliases.STRATEGY, getDictionaryValues().entrySet().stream()
                            .map(entry -> {
                                Long strategyId = entry.getKey();
                                return Map.of(
                                        "id", strategyId.toString(),
                                        "name", entry.getValue().getDefaultMessage(),
                                        "fields", strategyDefaultsFieldsService.getFields(
                                                strategyId,
                                                showVideoApplicableService.isShowVideoApplicableBySiteVersion(
                                                        extractSiteVersion(block),
                                                        block.getShowVideo()),
                                                block.getShowVideo()
                                        )
                                );
                            }).collect(Collectors.toList())
            );
        };
    }


    protected abstract String extractSiteVersion(B block);

}
