package ru.yandex.partner.jsonapi.models.block.parts;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Supplier;

import ru.yandex.partner.core.CoreConstants;
import ru.yandex.partner.core.entity.block.model.BlockWithContextPage;
import ru.yandex.partner.core.entity.page.filter.PageFilters;
import ru.yandex.partner.core.entity.page.model.ContextPage;
import ru.yandex.partner.core.entity.page.service.ReachablePageService;
import ru.yandex.partner.core.filter.CoreFilterNode;
import ru.yandex.partner.jsonapi.crnk.block.BlockCrnkJsonFieldAliases;
import ru.yandex.partner.jsonapi.crnk.fields.ApiField;
import ru.yandex.partner.jsonapi.models.AbstractApiModelPart;
import ru.yandex.partner.jsonapi.utils.function.BatchFunction;


public class ApiCpmCurrencyModelPart<B extends BlockWithContextPage>
        extends AbstractApiModelPart<B> {

    private final ReachablePageService<B> reachablePageService;
    private final Supplier<CoreFilterNode<ContextPage>> authPageFilterProvider;

    public ApiCpmCurrencyModelPart(String modelName,
                                   ReachablePageService<B> reachablePageService,
                                   Supplier<CoreFilterNode<ContextPage>> authPageFilterProvider) {
        super(modelName);
        this.reachablePageService = reachablePageService;
        this.authPageFilterProvider = authPageFilterProvider;
    }

    @Override
    public List<ApiField<B>> getFields() {
        return List.of(
                ApiField.<B, String, ContextPage>readableApiField(
                                String.class,
                                B.CAMPAIGN,
                                BatchFunction.one(block -> Objects.requireNonNullElse(
                                        block.getCampaign().getOwner().getCurrentCurrency(),
                                        CoreConstants.Currency.DEFAULT)))
                        .withDefaultsFunction(context -> {
                            B block = context.getModelFromAttributes();
                            if (block.getPageId() == null) {
                                Map<String, Object> currency = new HashMap<>();
                                currency.put(BlockCrnkJsonFieldAliases.CURRENT_CURRENCY, null);
                                return currency;
                            }
                            Optional<ContextPage> optPage = reachablePageService.getReachablePages(
                                    authPageFilterProvider.get()
                                            .and(CoreFilterNode.eq(PageFilters.PAGE_ID,
                                                    block.getPageId())),
                                    ContextPage.class
                            ).stream().findAny();

                            return optPage.map(page -> Map.of(
                                            BlockCrnkJsonFieldAliases.CURRENT_CURRENCY,
                                            (Object) Objects.requireNonNullElse(
                                                    page.getOwner().getCurrentCurrency(),
                                                    CoreConstants.Currency.DEFAULT
                                            ))).orElse(Collections.emptyMap());
                        })
                        .build(BlockCrnkJsonFieldAliases.CURRENT_CURRENCY)
        );
    }
}
