package ru.yandex.partner.jsonapi.models.block.parts;

import java.time.LocalDateTime;
import java.util.List;

import ru.yandex.partner.core.entity.block.model.BlockWithCreateDate;
import ru.yandex.partner.jsonapi.crnk.block.BlockCrnkJsonFieldAliases;
import ru.yandex.partner.jsonapi.crnk.fields.ApiField;
import ru.yandex.partner.jsonapi.models.ApiModelPart;

public class ApiCreateDateModelPart<B extends BlockWithCreateDate> implements ApiModelPart<B> {
    @Override
    public List<ApiField<B>> getFields() {
        return List.of(
                ApiField
                        .<B, LocalDateTime>convertibleApiField(LocalDateTime.class, B.CREATE_DATE)
                        .build(BlockCrnkJsonFieldAliases.CREATE_DATE)
        );
    }
}
