package ru.yandex.partner.jsonapi.models.block.parts;

import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

import ru.yandex.partner.core.entity.block.model.BlockWithCustomBkOptions;
import ru.yandex.partner.core.entity.custombkoptions.CustomBkOptionsTypedRepository;
import ru.yandex.partner.core.entity.custombkoptions.filter.CustomBkOptionsFilters;
import ru.yandex.partner.core.entity.custombkoptions.model.CustomBkOptions;
import ru.yandex.partner.core.filter.CoreFilterNode;
import ru.yandex.partner.core.filter.operator.FilterOperator;
import ru.yandex.partner.core.multistate.custombkoptions.CustomBkOptionsStateFlag;
import ru.yandex.partner.jsonapi.crnk.block.BlockCrnkJsonFieldAliases;
import ru.yandex.partner.jsonapi.crnk.fields.ApiField;
import ru.yandex.partner.jsonapi.crnk.fields.ApiFieldsAccessRulesFunction;
import ru.yandex.partner.jsonapi.models.AbstractApiModelPart;
import ru.yandex.partner.jsonapi.models.ModelClassUtils;
import ru.yandex.partner.jsonapi.models.block.BlockRightNames;
import ru.yandex.partner.jsonapi.models.block.access.HasRightAccessRuleFunction;

import static java.util.function.Predicate.not;
import static ru.yandex.partner.jsonapi.crnk.fields.ApiFieldsAccessRules.checkableByRight;
import static ru.yandex.partner.jsonapi.crnk.fields.ApiFieldsAccessRulesFunction.checkableAnd;
import static ru.yandex.partner.libs.multistate.MultistatePredicates.has;

public class ApiCustomBkOptionsModelPart<B extends BlockWithCustomBkOptions>
        extends AbstractApiModelPart<B> implements GodModeAvailable<B> {

    private final CustomBkOptionsTypedRepository customBkOptionsTypedRepository;
    private final GodModeAvailable<B> delegateGodModeAvailable;

    public ApiCustomBkOptionsModelPart(String modelName,
                                       CustomBkOptionsTypedRepository customBkOptionsTypedRepository,
                                       GodModeAvailable<B> godModeAvailable) {
        super(modelName);
        this.customBkOptionsTypedRepository = customBkOptionsTypedRepository;
        this.delegateGodModeAvailable = godModeAvailable;
    }

    @Override
    public List<ApiField<B>> getFields() {
        return List.of(
                ApiField
                        .<B, List<Long>>convertibleApiField(ModelClassUtils.getListClass(Long.class),
                                B.CUSTOM_BK_OPTIONS)
                        .withAvailableFunction(checkableByRight(
                                BlockRightNames.VIEW_FIELD__CUSTOM_BK_OPTIONS.getFullRightName(getModelName())))
                        .withEditableFunction(checkableAnd(List.of(
                                new HasRightAccessRuleFunction<>(
                                        BlockRightNames.EDIT_FIELD__CUSTOM_BK_OPTIONS.getFullRightName(getModelName())),
                                isGodModeEditableFunction())))
                        .withAddFieldFunction(checkableByRight(BlockRightNames.EDIT_FIELD__CUSTOM_BK_OPTIONS
                                .getFullRightName(getModelName())))
                        .withDefaultsFunction(paramsContext -> {
                            var notDeletedFilter = CoreFilterNode.create(
                                    CustomBkOptionsFilters.MULTISTATE,
                                    FilterOperator.IN,
                                    not(has(CustomBkOptionsStateFlag.DELETED))
                            );
                            List<CustomBkOptions> bkOptions = customBkOptionsTypedRepository.getAll(
                                    notDeletedFilter,
                                    Set.of(
                                            CustomBkOptions.ID,
                                            CustomBkOptions.NAME,
                                            CustomBkOptions.DESCRIPTION)
                            );
                            return Map.of(
                                    BlockCrnkJsonFieldAliases.CUSTOM_BK_OPTIONS,
                                    bkOptions.stream()
                                            .map(bkOpt -> Map.of(
                                                    "description", bkOpt.getDescription(),
                                                    "id", bkOpt.getId(),
                                                    "name", bkOpt.getName())
                                            ).collect(Collectors.toList())
                            );
                        })
                        .build(BlockCrnkJsonFieldAliases.CUSTOM_BK_OPTIONS)
        );
    }

    @Override
    public ApiFieldsAccessRulesFunction<B> isGodModeFunction() {
        return delegateGodModeAvailable.isGodModeFunction();
    }
}
