package ru.yandex.partner.jsonapi.models.block.parts;

import java.util.List;

import ru.yandex.partner.core.entity.block.model.BlockWithDesignTemplates;
import ru.yandex.partner.core.entity.designtemplates.model.DesignTemplates;
import ru.yandex.partner.jsonapi.crnk.block.BlockCrnkJsonFieldAliases;
import ru.yandex.partner.jsonapi.crnk.fields.ApiField;
import ru.yandex.partner.jsonapi.models.ApiModelPart;
import ru.yandex.partner.jsonapi.models.ModelClassUtils;

import static ru.yandex.partner.jsonapi.crnk.fields.ApiFieldsAccessRules.namedFunction;
import static ru.yandex.partner.jsonapi.models.FunctionNameEnum.GOD_MODE_FUNCTION;

public class ApiDesignTemplatesModelPart<B extends BlockWithDesignTemplates> implements ApiModelPart<B> {
    @Override
    public List<ApiField<B>> getFields() {
        return List.of(
                ApiField
                        .<B, List<DesignTemplates>>convertibleApiField(
                                ModelClassUtils.getListClass(DesignTemplates.class),
                                B.DESIGN_TEMPLATES
                        )
                        .withEditableFunction(namedFunction(GOD_MODE_FUNCTION))
                        .withAlwaysPermitAddFieldFunction()
                        .build(BlockCrnkJsonFieldAliases.DESIGN_TEMPLATES)
        );
    }
}
