package ru.yandex.partner.jsonapi.models.block.parts;

import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Function;

import ru.yandex.partner.core.entity.block.model.BlockWithDirectBlock;
import ru.yandex.partner.jsonapi.crnk.block.BlockCrnkJsonFieldAliases;
import ru.yandex.partner.jsonapi.crnk.fields.ApiField;
import ru.yandex.partner.jsonapi.crnk.fields.ApiFieldsAccessRules;
import ru.yandex.partner.jsonapi.crnk.fields.ApiFieldsAccessRulesFunction;
import ru.yandex.partner.jsonapi.crnk.fields.EditableData;
import ru.yandex.partner.jsonapi.crnk.fields.QueryParamsContext;
import ru.yandex.partner.jsonapi.models.AbstractApiModelPart;

import static ru.yandex.partner.jsonapi.crnk.fields.ApiFieldsAccessRules.checkable;
import static ru.yandex.partner.jsonapi.crnk.fields.ApiFieldsAccessRulesFunction.checkableAnd;

public abstract class ApiDirectBlockModelPart<B extends BlockWithDirectBlock> extends AbstractApiModelPart<B>
    implements GodModeAvailable<B> {

    private final String resourceType;

    public ApiDirectBlockModelPart(String resourceType) {
        super(resourceType);
        this.resourceType = resourceType;
    }

    @Override
    public List<ApiField<B>> getFields() {
        return List.of(
                ApiField
                        .<B, String>convertibleApiField(String.class, B.DIRECT_BLOCK)
                        .withAvailableFunction(getDirectBlockAvailableFunction())
                        .withAddFieldFunction(checkable(getAddFieldFunction()))
                        .withDefaultsFunction(getDefaultsFunction())
                        .withEditableFunction(checkableAnd(List.of(getEditableFunction(), isGodModeEditableFunction())))
                        .build(BlockCrnkJsonFieldAliases.DIRECT_BLOCK));
    }

    protected ApiFieldsAccessRulesFunction<EditableData<B>>  getEditableFunction() {
        return new ApiFieldsAccessRulesFunction<>(
                (userAuthentication, bEditableModelData) -> true);
    }

    protected Function<QueryParamsContext<B>, Map<String, Object>> getDefaultsFunction() {
        return bQueryParamsContext -> Map.of();
    }

    protected ApiFieldsAccessRulesFunction<EditableData<B>> getAddFieldFunction() {
        return new ApiFieldsAccessRulesFunction<>(
                (userAuthentication, bEditableModelData) -> true);
    }

    protected BiConsumer<String, ApiFieldsAccessRules.Builder<B>> getDirectBlockAvailableFunction() {
        return ApiFieldsAccessRules.alwaysPermit();
    }
}
