package ru.yandex.partner.jsonapi.models.block.parts;

import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Function;

import ru.yandex.partner.core.entity.block.model.BlockWithDspBlocks;
import ru.yandex.partner.jsonapi.crnk.block.BlockCrnkJsonFieldAliases;
import ru.yandex.partner.jsonapi.crnk.fields.ApiField;
import ru.yandex.partner.jsonapi.crnk.fields.ApiFieldsAccessRules;
import ru.yandex.partner.jsonapi.crnk.fields.ApiFieldsAccessRulesFunction;
import ru.yandex.partner.jsonapi.crnk.fields.EditableData;
import ru.yandex.partner.jsonapi.crnk.fields.QueryParamsContext;
import ru.yandex.partner.jsonapi.models.AbstractApiModelPart;
import ru.yandex.partner.jsonapi.models.ModelClassUtils;

import static ru.yandex.partner.jsonapi.crnk.fields.ApiFieldsAccessRules.alwaysPermit;
import static ru.yandex.partner.jsonapi.crnk.fields.ApiFieldsAccessRulesFunction.checkableAnd;

public abstract class ApiDspBlocksModelPart<B extends BlockWithDspBlocks> extends AbstractApiModelPart<B>
        implements GodModeAvailable<B> {

    public ApiDspBlocksModelPart(String modelName) {
        super(modelName);
    }

    @Override
    public List<ApiField<B>> getFields() {
        return List.of(
                ApiField
                        .<B, List<String>>convertibleApiField(ModelClassUtils.getListClass(String.class), B.DSP_BLOCKS)
                        .withAvailableFunction(getAvailableFunction())
                        .withEditableFunction(checkableAnd(List.of(
                                isGodModeEditableFunction(),
                                getEditableFunction())))
                        .withAddFieldFunction(getAddFieldFunction())
                        .withDefaultsFunction(getDefaultsFunction())
                        .build(BlockCrnkJsonFieldAliases.DSP_BLOCKS)
        );
    }

    protected ApiFieldsAccessRulesFunction<EditableData<B>> getEditableFunction() {
        return new ApiFieldsAccessRulesFunction<>(
                (userAuthentication, bEditableModelData) -> true);
    }

    protected BiConsumer<String, ApiFieldsAccessRules.Builder<EditableData<B>>> getAddFieldFunction() {
        return alwaysPermit();
    }

    protected abstract Function<QueryParamsContext<B>, Map<String, Object>> getDefaultsFunction();

    protected abstract BiConsumer<String, ApiFieldsAccessRules.Builder<B>> getAvailableFunction();

}
