package ru.yandex.partner.jsonapi.models.block.parts;

import java.util.Map;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.stream.Collectors;

import ru.yandex.partner.core.entity.block.model.BlockWithDspBlocks;
import ru.yandex.partner.core.entity.block.model.prop.BlockWithCustomBkDataFlagIsCustomBkDataPropHolder;
import ru.yandex.partner.core.entity.block.type.dspblocks.MediaBlockService;
import ru.yandex.partner.jsonapi.crnk.block.BlockCrnkJsonFieldAliases;
import ru.yandex.partner.jsonapi.crnk.exceptions.CrnkResponseStatusException;
import ru.yandex.partner.jsonapi.crnk.fields.ApiFieldsAccessRules;
import ru.yandex.partner.jsonapi.crnk.fields.ApiFieldsAccessRulesFunction;
import ru.yandex.partner.jsonapi.crnk.fields.QueryParamsContext;
import ru.yandex.partner.jsonapi.models.block.access.NotCustomBkDataAccessRuleFunction;
import ru.yandex.partner.libs.exceptions.HttpErrorStatusEnum;

public class ApiDspBlocksWithSiteVersionModelPart<B extends BlockWithDspBlocks &
        BlockWithCustomBkDataFlagIsCustomBkDataPropHolder> extends ApiDspBlocksModelPart<B> {
    private final MediaBlockService mediaBlockService;
    private final Function<B, String> getSiteVersion;

    public ApiDspBlocksWithSiteVersionModelPart(String modelName, MediaBlockService mediaBlockService,
                                                Function<B, String> getSiteVersion) {
        super(modelName);
        this.mediaBlockService = mediaBlockService;
        this.getSiteVersion = getSiteVersion;
    }

    @Override
    protected Function<QueryParamsContext<B>, Map<String, Object>> getDefaultsFunction() {
        return context -> {
            B block = Optional.ofNullable(context.getModelFromAttributes())
                    .orElseThrow(() -> new CrnkResponseStatusException(HttpErrorStatusEnum.ERROR__PARAMS));
            return Map.of(
                    BlockCrnkJsonFieldAliases.DSP_BLOCKS,
                    mediaBlockService.getDspBlockDataBySiteVersion(getSiteVersion.apply(block))
                            .stream()
                            .map(data -> Map.of(
                                    "id", data.getId(),
                                    "short_caption", data.getMsg().getDefaultMessage(),
                                    "site_version", data.getSiteVersions()
                            ))
                            .collect(Collectors.toList())
            );
        };
    }

    @Override
    protected BiConsumer<String, ApiFieldsAccessRules.Builder<B>> getAvailableFunction() {
        return ApiFieldsAccessRules.alwaysPermit();
    }

    @Override
    public ApiFieldsAccessRulesFunction<B> isGodModeFunction() {
        return new NotCustomBkDataAccessRuleFunction<B>();
    }
}
