package ru.yandex.partner.jsonapi.models.block.parts;

import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

import ru.yandex.partner.core.entity.block.model.BlockWithDspMode;
import ru.yandex.partner.core.entity.dsp.DspConstants.DspMode;
import ru.yandex.partner.jsonapi.crnk.block.BlockCrnkJsonFieldAliases;
import ru.yandex.partner.jsonapi.crnk.fields.ApiField;
import ru.yandex.partner.jsonapi.crnk.fields.ApiFieldsAccessRulesFunction;
import ru.yandex.partner.jsonapi.models.ApiModelPart;
import ru.yandex.partner.jsonapi.models.block.BlockRightNames;
import ru.yandex.partner.jsonapi.models.block.access.HasRightAccessRuleFunction;

import static ru.yandex.partner.core.utils.CollectionUtils.keyToList;
import static ru.yandex.partner.jsonapi.crnk.fields.ApiFieldsAccessRules.checkableByRight;
import static ru.yandex.partner.jsonapi.crnk.fields.ApiFieldsAccessRulesFunction.checkableAnd;

public class ApiDspModeModelPart<B extends BlockWithDspMode>
        implements ApiModelPart<B>, GodModeAvailable<B> {

    private final GodModeAvailable<B> godModeAvailableDelegate;
    private final String resourceType;
    // see https://st.yandex-team.ru/PI-29527 for more details
    private static final Set<String> EXCLUDED_DSP_MODES = Stream.of(DspMode.AUTO)
            .map(DspMode::getLiteral)
            .collect(Collectors.toSet());

    public ApiDspModeModelPart(String resourceType, GodModeAvailable<B> godModeAvailableDelegate) {
        this.resourceType = resourceType;
        this.godModeAvailableDelegate = godModeAvailableDelegate;
    }

    @Override
    public List<ApiField<B>> getFields() {
        return List.of(
                ApiField
                        .<B, String>convertibleApiField(String.class, B.DSP_MODE)
                        .withAvailableFunction(checkableByRight(
                                BlockRightNames.VIEW_FIELD__DSPS.getFullRightName(resourceType)))
                        .withEditableFunction(checkableAnd(List.of(
                                new HasRightAccessRuleFunction<>(
                                        BlockRightNames.EDIT_FIELD__DSPS.getFullRightName(resourceType)),
                                isGodModeEditableFunction()
                        )))
                        .withAddFieldFunction(checkableByRight(BlockRightNames.EDIT_FIELD__DSPS
                                .getFullRightName(resourceType)))
                        .withDefaultsFunction(
                                context -> DspMode.dspModeValues().stream()
                                        .filter(s -> !EXCLUDED_DSP_MODES.contains(s))
                                        .collect(keyToList(BlockCrnkJsonFieldAliases.DSP_MODE))
                        )
                        .build(BlockCrnkJsonFieldAliases.DSP_MODE)
        );
    }

    @Override
    public ApiFieldsAccessRulesFunction<B> isGodModeFunction() {
        return godModeAvailableDelegate.isGodModeFunction();
    }
}
