package ru.yandex.partner.jsonapi.models.block.parts;

import java.io.IOException;
import java.util.List;
import java.util.function.BiConsumer;

import com.fasterxml.jackson.databind.ObjectMapper;

import ru.yandex.partner.core.entity.block.model.BlockWithGeo;
import ru.yandex.partner.core.entity.block.model.Geo;
import ru.yandex.partner.core.utils.CommonConverters;
import ru.yandex.partner.core.validation.defects.DefectInfoBuilder;
import ru.yandex.partner.core.validation.defects.presentation.CommonValidationMsg;
import ru.yandex.partner.jsonapi.crnk.block.BlockCrnkJsonFieldAliases;
import ru.yandex.partner.jsonapi.crnk.fields.ApiField;
import ru.yandex.partner.jsonapi.crnk.fields.ApiFieldsAccessRules;
import ru.yandex.partner.jsonapi.crnk.fields.EditableData;
import ru.yandex.partner.jsonapi.models.AbstractApiModelPart;
import ru.yandex.partner.jsonapi.utils.function.BatchBiFunction;
import ru.yandex.partner.jsonapi.utils.function.BatchFunction;

import static ru.yandex.partner.jsonapi.crnk.fields.ApiFieldsAccessRules.namedFunction;
import static ru.yandex.partner.jsonapi.models.FunctionNameEnum.GOD_MODE_FUNCTION;

public class ApiGeoModelPart<B extends BlockWithGeo> extends AbstractApiModelPart<B> {
    private final ObjectMapper objectMapper;

    public ApiGeoModelPart(String modelName, ObjectMapper objectMapper) {
        super(modelName);
        this.objectMapper = objectMapper;
    }

    @Override
    public List<ApiField<B>> getFields() {
        return List.of(
                ApiField
                        .convertibleApiField(String.class, B.GEO,
                                BatchFunction.one(block ->
                                        CommonConverters.listToPrettyJsonString(objectMapper, block.getGeo())),
                                BatchBiFunction.<B, String>one((block, jsonString) -> {
                                    try {
                                        block.setGeo(CommonConverters.jsonStringToListThrowable(objectMapper,
                                                jsonString,
                                                Geo.class));
                                        return null;
                                    } catch (IOException e) {
                                        return List.of(DefectInfoBuilder.of(CommonValidationMsg.INCORRECT_JSON)
                                                .withValue(jsonString)
                                                .build()
                                        );
                                    }
                                }))
                        .withEditableFunction(namedFunction(GOD_MODE_FUNCTION))
                        .withAddFieldFunction(addAccessConsumer())
                        .build(BlockCrnkJsonFieldAliases.GEO),
                ApiField
                        .<B, Boolean>convertibleApiField(Boolean.class, B.HAS_GEO_SETTINGS)
                        .build(BlockCrnkJsonFieldAliases.HAS_GEO_SETTINGS)
        );
    }

    protected BiConsumer<String, ApiFieldsAccessRules.Builder<EditableData<B>>> addAccessConsumer() {
        return ApiFieldsAccessRules.alwaysPermit();
    }
}
