package ru.yandex.partner.jsonapi.models.block.parts;

import java.util.function.BiConsumer;

import com.fasterxml.jackson.databind.ObjectMapper;

import ru.yandex.partner.core.entity.block.model.BlockWithGeo;
import ru.yandex.partner.jsonapi.crnk.fields.ApiFieldsAccessRules;
import ru.yandex.partner.jsonapi.crnk.fields.EditableData;
import ru.yandex.partner.jsonapi.models.block.BlockRightNames;
import ru.yandex.partner.jsonapi.models.block.access.HasRightAccessRuleFunction;

public class ApiGeoWithRightModelPart<B extends BlockWithGeo> extends ApiGeoModelPart<B> {

    public ApiGeoWithRightModelPart(String modelName, ObjectMapper objectMapper) {
        super(modelName, objectMapper);
    }

    @Override
    protected BiConsumer<String, ApiFieldsAccessRules.Builder<EditableData<B>>> addAccessConsumer() {
        return ApiFieldsAccessRules.checkable(
                new HasRightAccessRuleFunction<>(BlockRightNames.EDIT_FIELD__GEO.getFullRightName(getModelName())));
    }
}
