package ru.yandex.partner.jsonapi.models.block.parts;

import java.util.List;

import ru.yandex.partner.core.entity.block.model.BlockWithRtbFields;
import ru.yandex.partner.jsonapi.crnk.block.BlockCrnkJsonFieldAliases;
import ru.yandex.partner.jsonapi.crnk.fields.ApiField;
import ru.yandex.partner.jsonapi.crnk.fields.ApiFieldsAccessRulesFunction;
import ru.yandex.partner.jsonapi.models.AbstractApiModelPart;

import static ru.yandex.partner.jsonapi.crnk.fields.ApiFieldsAccessRules.checkable;
import static ru.yandex.partner.jsonapi.crnk.fields.ApiFieldsAccessRulesFunction.checkableAnd;

public abstract class ApiHorizontalAlignModelPart<B extends BlockWithRtbFields>
        extends AbstractApiModelPart<B> implements GodModeAvailable<B> {

    public ApiHorizontalAlignModelPart(String modelName) {
        super(modelName);
    }

    @Override
    public List<ApiField<B>> getFields() {
        return List.of(
                ApiField
                        .<B, Boolean>convertibleApiField(Boolean.class, B.HORIZONTAL_ALIGN)
                        .withAvailableFunction(checkable(ApiFieldsAccessRulesFunction.alwaysAllow()))
                        .withEditableFunction(checkableAnd(List.of(
                                isGodModeEditableFunction()
                                ))
                        )
                        .withAlwaysPermitAddFieldFunction()
                        .build(BlockCrnkJsonFieldAliases.HORIZONTAL_ALIGN)
        );
    }

}

