package ru.yandex.partner.jsonapi.models.block.parts;

import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

import ru.yandex.partner.core.entity.block.filter.BlockFilters;
import ru.yandex.partner.core.entity.block.model.BlockWithMultistate;
import ru.yandex.partner.core.multistate.StateFlag;
import ru.yandex.partner.core.multistate.block.BlockStateFlag;
import ru.yandex.partner.jsonapi.constants.CrnkConstants;
import ru.yandex.partner.jsonapi.crnk.block.BlockCrnkJsonFieldAliases;
import ru.yandex.partner.jsonapi.crnk.fields.ApiField;
import ru.yandex.partner.jsonapi.crnk.filter.CrnkFilter;
import ru.yandex.partner.jsonapi.crnk.filter.description.provider.MultistateDictionaryValuesProvider;
import ru.yandex.partner.jsonapi.crnk.filter.parser.values.MultistateCrnkFilterValueParser;
import ru.yandex.partner.jsonapi.messages.block.RtbMsg;
import ru.yandex.partner.jsonapi.models.ApiModelPart;
import ru.yandex.partner.jsonapi.models.block.BlockFilterNameEnum;
import ru.yandex.partner.jsonapi.utils.function.BatchFunction;

public class ApiMultistateFieldsModelPart<B extends BlockWithMultistate, S extends StateFlag>
        implements ApiModelPart<B> {
    private final MultistateCrnkFilterValueParser<B, S> multistateCrnkFilterValueParser;

    public ApiMultistateFieldsModelPart(MultistateCrnkFilterValueParser<B, S> multistateCrnkFilterValueParser) {
        this.multistateCrnkFilterValueParser = multistateCrnkFilterValueParser;
    }

    @Override
    public List<ApiField<B>> getFields() {
        return List.of(
                ApiField
                        .readableApiField(
                                Boolean.class,
                                B.MULTISTATE,
                                BatchFunction.<B, Boolean>one(block ->
                                        block.getMultistate().test(BlockStateFlag.DELETED)))
                        .build(BlockCrnkJsonFieldAliases.IS_DELETED),
                ApiField
                        .readableApiField(
                                Boolean.class,
                                B.MULTISTATE,
                                BatchFunction.<B, Boolean>one(block ->
                                        !block.getMultistate().test(BlockStateFlag.CHECK_STATISTICS)))
                        .build(BlockCrnkJsonFieldAliases.STATISTICS_EXISTS),
                ApiField
                        .readableApiField(
                                String.class,
                                B.MULTISTATE,
                                BatchFunction.<B, String>one(block ->
                                        block.getMultistate().test(BlockStateFlag.NEED_UPDATE
                                                .or(BlockStateFlag.UPDATING))
                                                ? CrnkConstants.STATUS_PENDING
                                                : CrnkConstants.STATUS_SYNC))
                        .build(BlockCrnkJsonFieldAliases.STATUS),
                ApiField
                        .readableApiField(
                                Boolean.class,
                                B.MULTISTATE,
                                BatchFunction.<B, Boolean>one(block ->
                                        block.getMultistate().test(BlockStateFlag.NEED_UPDATE
                                                .or(BlockStateFlag.UPDATING))))
                        .build(BlockCrnkJsonFieldAliases.IS_UPDATING)
        );
    }

    @Override
    public Map<String, CrnkFilter<B, ?>> getFilters() {
        var list = List.<CrnkFilter<B, ?>>of(
                CrnkFilter.builder(BlockFilterNameEnum.MULTISTATE)
                        .setLabel(RtbMsg.STATUS)
                        .setExposed(() -> true)
                        .toCrnkFilter(
                                BlockFilters.MULTISTATE.asLongFilter(),
                                multistateCrnkFilterValueParser,
                                new MultistateDictionaryValuesProvider<>(BlockStateFlag.class)
                        )
        );

        return list.stream()
                .collect(Collectors.toMap(
                        CrnkFilter::getName,
                        baseBlockCrnkFilter -> baseBlockCrnkFilter
                ));
    }
}
