package ru.yandex.partner.jsonapi.models.block.parts;

import java.util.List;

import ru.yandex.partner.core.entity.block.model.BlockWithOnlyPortalTrustedBanners;
import ru.yandex.partner.jsonapi.crnk.block.BlockCrnkJsonFieldAliases;
import ru.yandex.partner.jsonapi.crnk.fields.ApiField;
import ru.yandex.partner.jsonapi.crnk.fields.ApiFieldsAccessRulesFunction;
import ru.yandex.partner.jsonapi.models.AbstractApiModelPart;
import ru.yandex.partner.jsonapi.models.block.BlockRightNames;
import ru.yandex.partner.jsonapi.models.block.access.HasRightAccessRuleFunction;

import static ru.yandex.partner.jsonapi.crnk.fields.ApiFieldsAccessRules.checkableByRight;
import static ru.yandex.partner.jsonapi.crnk.fields.ApiFieldsAccessRulesFunction.checkableAnd;

public class ApiOnlyPortalTrustedBannersModelPart<B extends BlockWithOnlyPortalTrustedBanners>
        extends AbstractApiModelPart<B> implements GodModeAvailable<B> {

    private final GodModeAvailable<B> delegateGodModeAvailable;

    public ApiOnlyPortalTrustedBannersModelPart(String modelName, GodModeAvailable<B> godModeAvailable) {
        super(modelName);
        this.delegateGodModeAvailable = godModeAvailable;
    }

    @Override
    public List<ApiField<B>> getFields() {
        return List.of(
                ApiField
                        .<B, Boolean>convertibleApiField(Boolean.class, B.ONLY_PORTAL_TRUSTED_BANNERS)
                        .withAvailableFunction(checkableByRight(BlockRightNames.
                                VIEW_FIELD__ONLY_PORTAL_TRUSTED_BANNERS.getFullRightName(getModelName())))
                        .withEditableFunction(checkableAnd(List.of(
                                new HasRightAccessRuleFunction<>(BlockRightNames.
                                        EDIT_FIELD__ONLY_PORTAL_TRUSTED_BANNERS.getFullRightName(getModelName())),
                                isGodModeEditableFunction())))
                        .withAddFieldFunction(checkableByRight(BlockRightNames.EDIT_FIELD__ONLY_PORTAL_TRUSTED_BANNERS
                                .getFullRightName(getModelName())))
                        .build(BlockCrnkJsonFieldAliases.ONLY_PORTAL_TRUSTED_BANNERS)
        );
    }


    @Override
    public ApiFieldsAccessRulesFunction<B> isGodModeFunction() {
        return delegateGodModeAvailable.isGodModeFunction();
    }
}
