package ru.yandex.partner.jsonapi.models.block.parts;

import java.util.List;
import java.util.Map;

import ru.yandex.partner.core.entity.block.model.BlockWithPCode;
import ru.yandex.partner.jsonapi.crnk.block.BlockCrnkJsonFieldAliases;
import ru.yandex.partner.jsonapi.crnk.fields.ApiField;
import ru.yandex.partner.jsonapi.crnk.fields.ApiFieldsAccessRules;
import ru.yandex.partner.jsonapi.models.ApiModelPart;
import ru.yandex.partner.jsonapi.models.ModelClassUtils;

import static ru.yandex.partner.jsonapi.crnk.fields.ApiFieldsAccessRules.namedFunction;
import static ru.yandex.partner.jsonapi.models.FunctionNameEnum.GOD_MODE_FUNCTION;

public class ApiPCodeBlockModelPart<B extends BlockWithPCode> implements ApiModelPart<B> {

    @Override
    public List<ApiField<B>> getFields() {
        return List.of(
                ApiField.<B, Map<String, Object>>convertibleApiField(
                                ModelClassUtils.getMapClass(String.class, Object.class),
                                B.P_CODE_SETTINGS)
                        .withAvailableFunction(ApiFieldsAccessRules.alwaysPermit())
                        .withAddFieldFunction(ApiFieldsAccessRules.alwaysPermit())
                        .withEditableFunction(namedFunction(GOD_MODE_FUNCTION))
                        .build(BlockCrnkJsonFieldAliases.P_CODE_SETTINGS)
        );
    }
}
