package ru.yandex.partner.jsonapi.models.block.parts;

import java.util.List;

import ru.yandex.partner.core.entity.block.model.BlockWithPiCategories;
import ru.yandex.partner.core.entity.block.model.PiCategory;
import ru.yandex.partner.jsonapi.crnk.block.BlockCrnkJsonFieldAliases;
import ru.yandex.partner.jsonapi.crnk.fields.ApiField;
import ru.yandex.partner.jsonapi.models.AbstractApiModelPart;
import ru.yandex.partner.jsonapi.models.ModelClassUtils;
import ru.yandex.partner.jsonapi.models.block.BlockRightNames;

import static ru.yandex.partner.jsonapi.crnk.fields.ApiFieldsAccessRules.checkableByRight;
import static ru.yandex.partner.jsonapi.crnk.fields.ApiFieldsAccessRules.namedFunction;
import static ru.yandex.partner.jsonapi.models.FunctionNameEnum.GOD_MODE_FUNCTION;

public class ApiPiCategoriesModelPart<B extends BlockWithPiCategories> extends AbstractApiModelPart<B> {
    public ApiPiCategoriesModelPart(String modelName) {
        super(modelName);
    }

    @Override
    public List<ApiField<B>> getFields() {
        return List.of(
                ApiField
                        .<B, List<PiCategory>>convertibleApiField(ModelClassUtils.getListClass(PiCategory.class),
                                B.PI_CATEGORIES)
                        .withEditableFunction(namedFunction(GOD_MODE_FUNCTION))
                        .withAddFieldFunction(checkableByRight(BlockRightNames.EDIT_FIELD__PICATEGORIES
                                .getFullRightName(getModelName())))
                        .build(BlockCrnkJsonFieldAliases.PI_CATEGORIES),
                ApiField
                        .<B, Boolean>convertibleApiField(Boolean.class, B.HAS_PI_CATEGORIES_SETTINGS)
                        .build(BlockCrnkJsonFieldAliases.HAS_PICATEGORIES_SETTINGS)
        );
    }
}
