package ru.yandex.partner.jsonapi.models.block.parts;

import java.util.List;

import ru.yandex.partner.core.entity.block.model.BlockWithReadonly;
import ru.yandex.partner.jsonapi.crnk.block.BlockCrnkJsonFieldAliases;
import ru.yandex.partner.jsonapi.crnk.fields.ApiField;
import ru.yandex.partner.jsonapi.crnk.fields.ApiFieldsAccessRulesFunction;
import ru.yandex.partner.jsonapi.models.AbstractApiModelPart;
import ru.yandex.partner.jsonapi.models.block.BlockRightNames;
import ru.yandex.partner.jsonapi.models.block.access.HasRightAccessRuleFunction;

import static ru.yandex.partner.jsonapi.crnk.fields.ApiFieldsAccessRules.checkableByRight;
import static ru.yandex.partner.jsonapi.crnk.fields.ApiFieldsAccessRulesFunction.checkableAnd;

public class ApiReadonlyModelPart<B extends BlockWithReadonly>
        extends AbstractApiModelPart<B> implements GodModeAvailable<B> {

    private final GodModeAvailable<B> delegateGodModeAvailable;

    public ApiReadonlyModelPart(String modelName, GodModeAvailable<B> godModeAvailable) {
        super(modelName);
        this.delegateGodModeAvailable = godModeAvailable;
    }

    @Override
    public List<ApiField<B>> getFields() {
        return List.of(
                ApiField
                        .<B, Boolean>convertibleApiField(Boolean.class, BlockWithReadonly.READONLY)
                        .withEditableFunction(checkableAnd(List.of(
                                new HasRightAccessRuleFunction<>(
                                        BlockRightNames.EDIT_FIELD__READONLY.getFullRightName(getModelName())),
                                isGodModeEditableFunction())))
                        .withAddFieldFunction(checkableByRight(BlockRightNames.EDIT_FIELD__READONLY
                                .getFullRightName(getModelName())))
                        .build(BlockCrnkJsonFieldAliases.READONLY)
        );
    }


    @Override
    public ApiFieldsAccessRulesFunction<B> isGodModeFunction() {
        return delegateGodModeAvailable.isGodModeFunction();
    }
}
