package ru.yandex.partner.jsonapi.models.block.parts;

import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

import ru.yandex.partner.core.entity.block.filter.BlockFilters;
import ru.yandex.partner.core.entity.block.model.BlockWithSiteVersion;
import ru.yandex.partner.jsonapi.crnk.block.BlockCrnkJsonFieldAliases;
import ru.yandex.partner.jsonapi.crnk.block.filter.SiteVersionValueParserAndProvider;
import ru.yandex.partner.jsonapi.crnk.fields.ApiField;
import ru.yandex.partner.jsonapi.crnk.fields.QueryParamsContext;
import ru.yandex.partner.jsonapi.crnk.filter.CrnkFilter;
import ru.yandex.partner.jsonapi.messages.block.RtbMsg;
import ru.yandex.partner.jsonapi.models.AbstractApiModelPart;
import ru.yandex.partner.jsonapi.models.block.BlockFilterNameEnum;
import ru.yandex.partner.jsonapi.models.block.BlockRightNames;
import ru.yandex.partner.jsonapi.models.block.access.HasRightAccessRuleFunction;

import static ru.yandex.partner.jsonapi.crnk.fields.ApiFieldsAccessRulesFunction.checkableAnd;

public abstract class ApiSiteVersionModelPart<B extends BlockWithSiteVersion>
        extends AbstractApiModelPart<B> implements GodModeAvailable<B> {

    private final SiteVersionValueParserAndProvider siteVersionValueParserAndProvider;

    public ApiSiteVersionModelPart(
            String modelName,
            SiteVersionValueParserAndProvider siteVersionValueParserAndProvider
    ) {
        super(modelName);
        this.siteVersionValueParserAndProvider = siteVersionValueParserAndProvider;
    }


    @Override
    public List<ApiField<B>> getFields() {
        return List.of(
                ApiField
                        .<B, String>convertibleApiField(String.class, B.SITE_VERSION)
                        .withEditableFunction(checkableAnd(List.of(
                                new HasRightAccessRuleFunction<>(
                                        BlockRightNames.EDIT_FIELD__SITE_VERSION.getFullRightName(getModelName())),
                                isGodModeEditableFunction())))
                        .withAlwaysPermitAddFieldFunction()
                        .withDefaultsFunction(this::getSiteVersionDefaults)
                        .build(BlockCrnkJsonFieldAliases.SITE_VERSION)
        );
    }

    @Override
    public Map<String, CrnkFilter<B, ?>> getFilters() {

        var list = List.<CrnkFilter<B, ?>>of(
                CrnkFilter.builder(BlockFilterNameEnum.SITE_VERSION)
                        .setLabel(RtbMsg.SITE_VERSION)
                        .setExposed(() -> true)
                        .toCrnkFilter(
                                BlockFilters.SITE_VERSION,
                                siteVersionValueParserAndProvider,
                                siteVersionValueParserAndProvider
                        )
        );
        return list.stream()
                .collect(Collectors.toMap(
                        CrnkFilter::getName,
                        baseBlockCrnkFilter -> baseBlockCrnkFilter
                ));
    }

    protected abstract Map<String, Object> getSiteVersionDefaults(QueryParamsContext<B> paramsContext);

    protected String getSiteVersionLabel(String version) {
        return siteVersionValueParserAndProvider.getSiteVersionLabel(version);
    }
}
