package ru.yandex.partner.jsonapi.models.block.parts;

import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

import ru.yandex.partner.core.entity.block.model.BlockWithTags;
import ru.yandex.partner.core.entity.block.type.tags.TagService;
import ru.yandex.partner.jsonapi.crnk.block.BlockCrnkJsonFieldAliases;
import ru.yandex.partner.jsonapi.crnk.fields.ApiField;
import ru.yandex.partner.jsonapi.crnk.fields.ApiFieldsAccessRulesFunction;
import ru.yandex.partner.jsonapi.models.AbstractApiModelPart;
import ru.yandex.partner.jsonapi.models.ModelClassUtils;
import ru.yandex.partner.jsonapi.models.block.BlockRightNames;
import ru.yandex.partner.jsonapi.models.block.access.HasRightAccessRuleFunction;

import static ru.yandex.partner.jsonapi.crnk.fields.ApiFieldsAccessRules.checkableByRight;
import static ru.yandex.partner.jsonapi.crnk.fields.ApiFieldsAccessRulesFunction.checkableAnd;

public class ApiTagsModelPart<B extends BlockWithTags>
        extends AbstractApiModelPart<B> implements GodModeAvailable<B> {

    private final TagService tagService;
    private final GodModeAvailable<B> delegateGodModeAvailable;

    public ApiTagsModelPart(String modelName, TagService tagService, GodModeAvailable<B> godModeAvailable) {
        super(modelName);
        this.tagService = tagService;
        this.delegateGodModeAvailable = godModeAvailable;
    }

    @Override
    public List<ApiField<B>> getFields() {
        return List.of(
                ApiField
                        .<B, List<Long>>convertibleApiField(ModelClassUtils.getListClass(Long.class), B.ORDER_TAGS)
                        .withAvailableFunction(checkableByRight(
                                BlockRightNames.VIEW_FIELD__ORDER_TAGS.getFullRightName(getModelName())))
                        .withEditableFunction(checkableAnd(List.of(
                                new HasRightAccessRuleFunction<>(
                                        BlockRightNames.EDIT_FIELD__ORDER_TAGS.getFullRightName(getModelName())),
                                isGodModeEditableFunction())))
                        .withAddFieldFunction(checkableByRight(BlockRightNames.EDIT_FIELD__ORDER_TAGS
                                .getFullRightName(getModelName())))
                        .build(BlockCrnkJsonFieldAliases.ORDER_TAGS),
                ApiField
                        .<B, List<Long>>convertibleApiField(ModelClassUtils.getListClass(Long.class), B.TARGET_TAGS)
                        .withAvailableFunction(checkableByRight(
                                BlockRightNames.VIEW_FIELD__TARGET_TAGS.getFullRightName(getModelName())))
                        .withEditableFunction(checkableAnd(List.of(
                                new HasRightAccessRuleFunction<>(
                                        BlockRightNames.EDIT_FIELD__TARGET_TAGS.getFullRightName(getModelName())),
                                isGodModeEditableFunction())))
                        .withAddFieldFunction(checkableByRight(BlockRightNames.EDIT_FIELD__TARGET_TAGS
                                .getFullRightName(getModelName())))
                        .withDefaultsFunction(paramsContext -> Map.of(
                                        BlockCrnkJsonFieldAliases.TARGET_TAGS,
                                        tagService.getTags().values().stream()
                                                .map(tag -> Map.of(
                                                                "descr", tag.getDescr(),
                                                                "id", tag.getId()
                                                        )
                                                ).collect(Collectors.toList())
                                )
                        ).build(BlockCrnkJsonFieldAliases.TARGET_TAGS)
        );
    }

    @Override
    public ApiFieldsAccessRulesFunction<B> isGodModeFunction() {
        return delegateGodModeAvailable.isGodModeFunction();
    }
}
