package ru.yandex.partner.jsonapi.models.block.parts;

import java.util.List;
import java.util.Objects;

import javax.annotation.Nullable;

import ru.yandex.partner.core.entity.block.model.BlockWithCommonShowVideo;
import ru.yandex.partner.core.entity.block.model.RtbBlock;
import ru.yandex.partner.core.entity.block.model.prop.BlockWithSiteVersionSiteVersionPropHolder;
import ru.yandex.partner.core.entity.block.type.commonshowvideo.ShowVideoApplicableService;
import ru.yandex.partner.core.entity.block.type.commonshowvideoandstrategy.SiteVersionType;
import ru.yandex.partner.jsonapi.crnk.fields.ApiFieldsAccessRulesFunction;
import ru.yandex.partner.jsonapi.crnk.fields.EditableData;
import ru.yandex.partner.jsonapi.models.block.BlockRightNames;
import ru.yandex.partner.libs.auth.model.UserAuthentication;

public class BaseShowVideoAvailable<B extends BlockWithCommonShowVideo & BlockWithSiteVersionSiteVersionPropHolder>
        implements ShowVideoAvailable<B> {
    private final String modelName;
    private final ShowVideoApplicableService showVideoApplicableService;

    public BaseShowVideoAvailable(String modelName, ShowVideoApplicableService showVideoApplicableService) {
        this.modelName = modelName;
        this.showVideoApplicableService = showVideoApplicableService;
    }

    @Override
    public ApiFieldsAccessRulesFunction<B> showVideoAvailableFunction() {
        return new ApiFieldsAccessRulesFunction<>((userAuthentication, block) ->
                isShowVideo(modelName, userAuthentication, block, null),
                List.of(BlockWithSiteVersionSiteVersionPropHolder.SITE_VERSION,
                        BlockWithCommonShowVideo.SHOW_VIDEO));
    }

    @Override
    public ApiFieldsAccessRulesFunction<EditableData<B>> showVideoEditableFunction() {
        return new ApiFieldsAccessRulesFunction<>((userAuthentication, editableRtbBlock) ->
                isShowVideo(modelName, userAuthentication,
                        editableRtbBlock.getActual(),
                        editableRtbBlock.getPatched()),
                List.of(BlockWithSiteVersionSiteVersionPropHolder.SITE_VERSION, BlockWithCommonShowVideo.SHOW_VIDEO));
    }

    @Override
    public ApiFieldsAccessRulesFunction<EditableData<B>> showVideoAddFunction() {
        return new ApiFieldsAccessRulesFunction<>((userAuthentication, block) ->
                Boolean.TRUE.equals(block.getActual().getShowVideo()));
    }

    @Override
    public ApiFieldsAccessRulesFunction<EditableData<B>> isShowVideoApplicableFunction() {
        return new ApiFieldsAccessRulesFunction<>(
                (userAuthentication, rtbBlockEditableData) ->
                        showVideoApplicableService.isShowVideoApplicableBySiteVersion(
                                rtbBlockEditableData.getActual().getSiteVersion(),
                                rtbBlockEditableData.getActual().getShowVideo()
                        ),
                List.of(RtbBlock.SITE_VERSION, RtbBlock.SHOW_VIDEO)
        );
    }

    @Override
    public boolean isShowVideo(String modelName, UserAuthentication userAuthentication, B actual, @Nullable B patched) {

        B block = Objects.requireNonNullElse(patched, actual);
        var rightName = BlockRightNames.VIEW_FIELD__SHOW_VIDEO.getFullRightName(modelName);
        if (!(userAuthentication.userHasRight(rightName) || Boolean.TRUE.equals(block.getShowVideo()))) {
            return false;
        }
        if (SiteVersionType.AMP.getLiteral().equals(block.getSiteVersion())) {
            return false;
        }
        return !SiteVersionType.TURBO_DESKTOP.getLiteral().equals(block.getSiteVersion())
                || Boolean.TRUE.equals(actual.getShowVideo());
    }

    @Override
    public boolean isShowVideoApplicable(String modelName, UserAuthentication userAuthentication, B block) {
        return showVideoApplicableService.isShowVideoApplicableBySiteVersion(
                block.getSiteVersion(),
                block.getShowVideo());
    }
}
