package ru.yandex.partner.jsonapi.models.block.parts;

import ru.yandex.partner.core.entity.block.model.BaseBlock;
import ru.yandex.partner.jsonapi.crnk.fields.ApiFieldsAccessRulesFunction;
import ru.yandex.partner.jsonapi.crnk.fields.EditableData;

public interface GodModeAvailable<B extends BaseBlock> {
    ApiFieldsAccessRulesFunction<B> isGodModeFunction();

    default ApiFieldsAccessRulesFunction<EditableData<B>> isGodModeEditableFunction() {
        var available = isGodModeFunction();
        return new ApiFieldsAccessRulesFunction<>(
                (userAuthentication, bEditableModelData) -> available.getAccessRuleFunction().apply(
                        userAuthentication,
                        bEditableModelData.getPatchedOrElseActual()
                ),
                available.getRequiredProperties()
        );
    }
}
