package ru.yandex.partner.jsonapi.models.block.parts;

import javax.annotation.Nullable;

import ru.yandex.partner.core.entity.block.model.BaseBlock;
import ru.yandex.partner.jsonapi.crnk.fields.ApiFieldsAccessRulesFunction;
import ru.yandex.partner.jsonapi.crnk.fields.EditableData;
import ru.yandex.partner.libs.auth.model.UserAuthentication;

public interface ShowVideoAvailable<B extends BaseBlock> {
    ApiFieldsAccessRulesFunction<B> showVideoAvailableFunction();

    ApiFieldsAccessRulesFunction<EditableData<B>> showVideoEditableFunction();

    ApiFieldsAccessRulesFunction<EditableData<B>> showVideoAddFunction();

    ApiFieldsAccessRulesFunction<EditableData<B>> isShowVideoApplicableFunction();

    boolean isShowVideo(String modelName, UserAuthentication userAuthentication, B actual, @Nullable B patched);

    boolean isShowVideoApplicable(String modelName, UserAuthentication userAuthentication, B block);

    default boolean getDefaultShowVideoValue(B block) {
        return false;
    }
}
