package ru.yandex.partner.jsonapi.models.block.parts;

import java.util.List;
import java.util.Objects;

import javax.annotation.Nullable;

import ru.yandex.partner.core.entity.block.model.BlockWithBlockTypeAndShowVideo;
import ru.yandex.partner.core.entity.block.model.BlockWithCommonShowVideo;
import ru.yandex.partner.core.entity.block.model.prop.BlockWithBlockTypeBlockTypePropHolder;
import ru.yandex.partner.core.entity.block.type.dspshowvideoandblocktype.ShowVideoApplicableService;
import ru.yandex.partner.jsonapi.crnk.fields.ApiFieldsAccessRulesFunction;
import ru.yandex.partner.jsonapi.crnk.fields.EditableData;
import ru.yandex.partner.jsonapi.models.block.BlockRightNames;
import ru.yandex.partner.libs.auth.model.UserAuthentication;

import static ru.yandex.partner.jsonapi.models.block.BlockRightNames.EDIT_FIELD__RICH_MEDIA;

public class ShowVideoAvailableByBlockType<B extends BlockWithBlockTypeAndShowVideo>
        implements ShowVideoAvailable<B> {
    private final String modelName;
    private final ShowVideoApplicableService<BlockWithBlockTypeAndShowVideo> showVideoApplicableService;

    public ShowVideoAvailableByBlockType(
            String modelName,
            ShowVideoApplicableService<BlockWithBlockTypeAndShowVideo> showVideoApplicableService) {
        this.modelName = modelName;
        this.showVideoApplicableService = showVideoApplicableService;
    }

    @Override
    public ApiFieldsAccessRulesFunction<B> showVideoAvailableFunction() {
        return new ApiFieldsAccessRulesFunction<>((userAuthentication, block) ->
                isShowVideo(modelName, userAuthentication, block, null),
                List.of(BlockWithBlockTypeBlockTypePropHolder.BLOCK_TYPE,
                        BlockWithCommonShowVideo.SHOW_VIDEO));
    }

    @Override
    public ApiFieldsAccessRulesFunction<EditableData<B>> showVideoEditableFunction() {
        return isShowVideoApplicableFunction();
    }

    @Override
    public ApiFieldsAccessRulesFunction<EditableData<B>> showVideoAddFunction() {
        return new ApiFieldsAccessRulesFunction<>((userAuthentication, block) ->
                Boolean.TRUE.equals(block.getActual().getShowVideo()));
    }

    @Override
    public ApiFieldsAccessRulesFunction<EditableData<B>> isShowVideoApplicableFunction() {
        return new ApiFieldsAccessRulesFunction<>(
                (userAuthentication, rtbBlockEditableData) ->
                        showVideoApplicableService.isShowVideoApplicable(
                                rtbBlockEditableData.getPatchedOrElseActual(),
                                userAuthentication.userHasRight(EDIT_FIELD__RICH_MEDIA.getFullRightName(modelName))
                        ),
                List.of(BlockWithBlockTypeBlockTypePropHolder.BLOCK_TYPE, BlockWithCommonShowVideo.SHOW_VIDEO)
        );
    }

    @Override
    public boolean isShowVideo(String modelName, UserAuthentication userAuthentication, B actual, @Nullable B patched) {

        B block = Objects.requireNonNullElse(patched, actual);
        var rightName = BlockRightNames.VIEW_FIELD__SHOW_VIDEO.getFullRightName(modelName);
        if (!(userAuthentication.userHasRight(rightName) || Boolean.TRUE.equals(block.getShowVideo()))) {
            return false;
        }
        return showVideoApplicableService.isShowVideoApplicable(block, userAuthentication
                .userHasRight(EDIT_FIELD__RICH_MEDIA.getFullRightName(modelName)));

    }

    @Override
    public boolean isShowVideoApplicable(String modelName, UserAuthentication ua, B block) {
        return showVideoApplicableService.isShowVideoApplicable(
                block, ua.userHasRight(EDIT_FIELD__RICH_MEDIA.getFullRightName(modelName))
        );
    }

    @Override
    public boolean getDefaultShowVideoValue(B block) {
        return showVideoApplicableService.getDefaultValue(block);
    }


}
