package ru.yandex.partner.jsonapi.models.block.relationships;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

import io.crnk.core.engine.document.Relationship;
import io.crnk.core.engine.document.ResourceIdentifier;
import io.crnk.core.utils.Nullable;

import ru.yandex.partner.core.block.BlockUniqueIdConverter;
import ru.yandex.partner.core.entity.block.model.BaseBlock;
import ru.yandex.partner.jsonapi.models.ApiResourceType;
import ru.yandex.partner.jsonapi.models.relationships.OneApiRelationship;

public class PageOneApiRelationship<T extends BaseBlock> implements OneApiRelationship<T> {
    private final ApiResourceType apiResourceType;

    public PageOneApiRelationship(ApiResourceType apiResourceType) {
        this.apiResourceType = apiResourceType;
    }

    @Override
    public List<String> getFieldsForCalcId() {
        return List.of();
    }

    @Override
    public ApiResourceType getApiResourceType() {
        return apiResourceType;
    }

    @Override
    public String getField() {
        return getApiResourceType().getResourceType();
    }

    @Override
    public Relationship getRelationship(T model) {
        var relationship = new Relationship();
        relationship.setData(
                Nullable.of(new ResourceIdentifier(Long.toString(model.getPageId()),
                        getApiResourceType().getResourceType()))
        );
        return relationship;
    }

    @Override
    public Map<String, String> getSourceIdToTargetIdMap(Collection<String> sourceIds) {
        return sourceIds.stream().collect(Collectors.toMap(
                sourceId -> sourceId, BlockUniqueIdConverter::pageIdFromPublicId));
    }


}
