package ru.yandex.partner.jsonapi.models.block.rtb;

import ru.yandex.partner.core.entity.block.model.BlockWithCommonFields;
import ru.yandex.partner.core.entity.block.model.prop.BlockWithCustomBkDataFlagIsCustomBkDataPropHolder;
import ru.yandex.partner.jsonapi.crnk.fields.ApiFieldsAccessRulesFunction;
import ru.yandex.partner.jsonapi.models.block.BlockRightNames;
import ru.yandex.partner.jsonapi.models.block.access.NotCustomBkDataAccessRuleFunction;
import ru.yandex.partner.jsonapi.models.block.parts.ApiCommonModelPart;

public class ApiRtbCommonModelPart<B extends BlockWithCommonFields & BlockWithCustomBkDataFlagIsCustomBkDataPropHolder>
        extends ApiCommonModelPart<B> {
    private final ApiFieldsAccessRulesFunction<B> godModeFunction;

    public ApiRtbCommonModelPart(String modelName) {
        super(modelName);
        godModeFunction = new NotCustomBkDataAccessRuleFunction<>();
    }

    public ApiRtbCommonModelPart(String modelName, BlockRightNames editRight) {
        super(modelName, editRight);
        godModeFunction = new NotCustomBkDataAccessRuleFunction<>();
    }

    @Override
    public ApiFieldsAccessRulesFunction<B> isGodModeFunction() {
        return godModeFunction;
    }
}
