package ru.yandex.partner.jsonapi.models.block.rtb.external;

import java.util.Map;
import java.util.function.Function;
import java.util.function.Supplier;

import ru.yandex.partner.core.block.BlockUniqueIdConverter;
import ru.yandex.partner.core.entity.block.model.RtbBlock;
import ru.yandex.partner.core.entity.page.model.ContextPage;
import ru.yandex.partner.core.entity.page.service.ReachablePageService;
import ru.yandex.partner.core.filter.CoreFilterNode;
import ru.yandex.partner.jsonapi.crnk.CrnkModelFilters;
import ru.yandex.partner.jsonapi.crnk.authorization.request.RequestAuthorizationService;
import ru.yandex.partner.jsonapi.crnk.filter.parser.CrnkFilterParser;
import ru.yandex.partner.jsonapi.crnk.page.PageCrnkJsonFieldAliases;
import ru.yandex.partner.jsonapi.models.block.parts.ApiBaseBlockModelPart;
import ru.yandex.partner.libs.authorization.policy.base.Policy;

public class ApiRtbBaseBlockModelPart extends ApiBaseBlockModelPart<RtbBlock, ContextPage> {

    @SuppressWarnings("checkstyle:parameternumber")
    public ApiRtbBaseBlockModelPart(CrnkFilterParser crnkFilterParser,
                                    CrnkModelFilters<ContextPage> pageCrnkModelFilters,
                                    RequestAuthorizationService requestAuthorizationService,
                                    Policy<ContextPage> pagePolicy, BlockUniqueIdConverter.Prefixes prefix,
                                    ReachablePageService<RtbBlock> reachablePageService,
                                    Supplier<CoreFilterNode<ContextPage>> authPageFilterProvider,
                                    Class<ContextPage> pageClass, boolean needPageIdFilter) {
        super(crnkFilterParser, pageCrnkModelFilters, requestAuthorizationService, pagePolicy, prefix,
                reachablePageService, authPageFilterProvider, pageClass, needPageIdFilter);
    }

    @Override
    protected Function<ContextPage, Map<String, Object>> pageMapper() {
        return page -> Map.of(
                PageCrnkJsonFieldAliases.CAPTION, page.getCaption(),
                PageCrnkJsonFieldAliases.DOMAIN, page.getDomain(),
                PageCrnkJsonFieldAliases.PAGE_ID, page.getId()
        );
    }
}
