package ru.yandex.partner.jsonapi.models.block.rtb.external

import com.fasterxml.jackson.databind.ObjectMapper
import org.springframework.beans.factory.annotation.Value
import org.springframework.context.MessageSource
import org.springframework.context.annotation.Bean
import org.springframework.context.annotation.Configuration
import ru.yandex.direct.validation.presentation.DefectPresentationRegistry
import ru.yandex.partner.core.action.ActionPerformer
import ru.yandex.partner.core.block.BlockUniqueIdConverter
import ru.yandex.partner.core.entity.block.model.BaseBlock
import ru.yandex.partner.core.entity.block.model.BlockWithMultistate
import ru.yandex.partner.core.entity.block.model.RtbBlock
import ru.yandex.partner.core.entity.block.model.prop.BlockWithMultistateMultistatePropHolder
import ru.yandex.partner.core.entity.block.multistate.RtbBlockMultistateExpressionParser
import ru.yandex.partner.core.entity.block.multistate.RtbBlockMultistateGraph
import ru.yandex.partner.core.entity.block.service.BlockAddService
import ru.yandex.partner.core.entity.block.service.BlockService
import ru.yandex.partner.core.entity.block.type.commonshowvideo.ShowVideoApplicableService
import ru.yandex.partner.core.entity.block.type.dspblocks.MediaBlockService
import ru.yandex.partner.core.entity.block.type.siteversionandcontextpage.SiteVersionAvailabilityService
import ru.yandex.partner.core.entity.block.type.tags.TagService
import ru.yandex.partner.core.entity.common.editablefields.EditableFieldsService
import ru.yandex.partner.core.entity.custombkoptions.CustomBkOptionsTypedRepository
import ru.yandex.partner.core.entity.dsp.service.DspService
import ru.yandex.partner.core.entity.page.model.ContextPage
import ru.yandex.partner.core.entity.page.service.RtbReachablePageService
import ru.yandex.partner.core.entity.strategy.StrategyDefaultsFieldsService
import ru.yandex.partner.core.multistate.block.BlockStateFlag
import ru.yandex.partner.jsonapi.crnk.authorization.actions.ActionsAuthorizationService
import ru.yandex.partner.jsonapi.crnk.authorization.request.RequestAuthorizationService
import ru.yandex.partner.jsonapi.crnk.block.BlockCrnkJsonFieldAliases
import ru.yandex.partner.jsonapi.crnk.block.authorization.actions.BlockActionsAuthorizationService
import ru.yandex.partner.jsonapi.crnk.block.rtb.external.RtbBlockApiFieldsService
import ru.yandex.partner.jsonapi.crnk.filter.parser.CrnkFilterParser
import ru.yandex.partner.jsonapi.crnk.filter.parser.values.MultistateCrnkFilterValueParser
import ru.yandex.partner.jsonapi.crnk.multistate.MultistateService
import ru.yandex.partner.jsonapi.crnk.page.ExternalPageReachabilityService
import ru.yandex.partner.jsonapi.crnk.page.PageCrnkMapper
import ru.yandex.partner.jsonapi.crnk.page.PageCrnkModelFilters
import ru.yandex.partner.jsonapi.models.AccessFunctionComposite
import ru.yandex.partner.jsonapi.models.ApiModel
import ru.yandex.partner.jsonapi.models.ApiService
import ru.yandex.partner.jsonapi.models.DependsHolder
import ru.yandex.partner.jsonapi.models.block.ApiBlockService
import ru.yandex.partner.jsonapi.models.block.AuthBlockContainerConfigurer
import ru.yandex.partner.jsonapi.models.block.actions.BlockActionService
import ru.yandex.partner.jsonapi.models.block.parts.*
import ru.yandex.partner.jsonapi.models.block.rtb.ApiRtbCommonModelPart
import ru.yandex.partner.jsonapi.models.common.ApiActionsModelPart
import ru.yandex.partner.jsonapi.models.common.ApiFieldsDependsModelPart
import ru.yandex.partner.jsonapi.models.common.ApiMultistateModelPart
import ru.yandex.partner.jsonapi.models.common.ApiRequireFieldsModelPart
import ru.yandex.partner.jsonapi.models.page.external.ApiContextPageMetaData
import ru.yandex.partner.jsonapi.utils.ConfigurationUtils
import ru.yandex.partner.libs.auth.facade.AuthenticationFacade
import ru.yandex.partner.libs.authorization.policy.base.Policy
import ru.yandex.partner.libs.i18n.TranslatableError

@Configuration
open class ApiRtbConfiguration {
    @Bean
    open fun apiRtbService(
        apiRtbModel: ApiRtbModel,
        rtbBlockApiFieldsService: RtbBlockApiFieldsService,
        blockService: BlockService,
        actionPerformer: ActionPerformer,
        blockAddService: BlockAddService<BlockWithMultistate>,
        requestAuthorizationService: RequestAuthorizationService,
        defectRegistry: DefectPresentationRegistry<TranslatableError>,
        actionsAuthorizationService: ActionsAuthorizationService<RtbBlock>,
        blockActionService: BlockActionService<RtbBlock>,
        authBlockContainerConfigurer: RtbAuthBlockContainerConfigurer,
        pageMetaData: ApiContextPageMetaData
    ): ApiService<RtbBlock> {
        return ApiBlockService(
            actionPerformer,
            defectRegistry,
            requestAuthorizationService,
            actionsAuthorizationService,
            rtbBlockApiFieldsService,
            apiRtbModel,
            blockService,
            blockAddService,
            blockActionService,
            authBlockContainerConfigurer,
            pageMetaData
        )
    }

    @Bean
    open fun authBlockContainerConfigurer(
        authenticationFacade: AuthenticationFacade,
        pageReachabilityService: ExternalPageReachabilityService,
        rtbBlockApiModel: ApiModel<RtbBlock>,
        contextPageApiModel: ApiModel<ContextPage>
    ): AuthBlockContainerConfigurer<RtbBlock, ContextPage> {
        return RtbAuthBlockContainerConfigurer(
            authenticationFacade,
            pageReachabilityService,
            rtbBlockApiModel,
            contextPageApiModel
        )
    }

    @Bean
    open fun apiRtbModel(
        apiRtbMetaData: ApiRtbMetaData,
        apiContextPageMetaData: ApiContextPageMetaData,
        objectMapper: ObjectMapper,
        pageCrnkMapper: PageCrnkMapper,
        multistateService: MultistateService,
        crnkFilterParser: CrnkFilterParser,
        pageCrnkModelFilters: PageCrnkModelFilters,
        requestAuthorizationService: RequestAuthorizationService,
        pagePolicy: Policy<ContextPage>,
        rtbBlockPolicy: Policy<RtbBlock>,
        authenticationFacade: AuthenticationFacade,
        blockActionsAuthorizationService: BlockActionsAuthorizationService<RtbBlock>,
        rtbBlockMultistateGraph: RtbBlockMultistateGraph,
        rtbBlockMultistateExpressionParser: RtbBlockMultistateExpressionParser,
        rtbReachablePageService: RtbReachablePageService,
        pageReachabilityService: ExternalPageReachabilityService,
        pageApiModel: ApiModel<ContextPage>,
        siteVersionAvailabilityService: SiteVersionAvailabilityService,
        dspService: DspService,
        tagService: TagService,
        customBkOptionsTypedRepository: CustomBkOptionsTypedRepository,
        showVideoApplicableService: ShowVideoApplicableService,
        mediaBlockService: MediaBlockService,
        functionComposite: AccessFunctionComposite<RtbBlock>,
        editableFieldsService: EditableFieldsService<BaseBlock>,
        messageSource: MessageSource,
        @Value("\${partner.block.need-page-id-filter}") needPageIdFilter: Boolean,
        strategyDefaultsFieldsService: StrategyDefaultsFieldsService
    ): ApiRtbModel {
        val multistateCrnkFilterValueParser = MultistateCrnkFilterValueParser(
            rtbBlockMultistateGraph,
            rtbBlockMultistateExpressionParser
        )
        var supplier = {
            pageReachabilityService
                .reachablePagesFilter(pageApiModel)
                .and(pageReachabilityService.getNotProtectedFilter())
        };
        val modelParts = mutableListOf(
            ApiMultistateModelPart<BlockWithMultistateMultistatePropHolder, RtbBlock, BlockStateFlag>(
                multistateService, RtbBlock.MULTISTATE
            ),
            ApiAdfoxBlockModelPart(),
            ApiAlternativeCodeModelPart(),
            ApiAltSizeModelPart(),
            ApiRtbBaseBlockModelPart(
                crnkFilterParser,
                pageCrnkModelFilters,
                requestAuthorizationService,
                pagePolicy,
                BlockUniqueIdConverter.Prefixes.CONTEXT_ON_SITE_RTB_PREFIX,
                rtbReachablePageService,  // deferred for thread-local auth
                supplier,
                ContextPage::class.java,
                needPageIdFilter
            ),
            ApiBrandsModelPart(),
            ApiCampaignModelPart(apiContextPageMetaData, pageCrnkMapper, authenticationFacade),
            // deferred for thread-local auth
            ApiCpmCurrencyModelPart(apiRtbMetaData.resourceType, rtbReachablePageService, supplier),
            ApiRtbCommonModelPart(apiRtbMetaData.resourceType),
            ApiCommonShowVideoWithDelegateModelPart<RtbBlock>(
                apiRtbMetaData.resourceType,
                BaseShowVideoAvailable(apiRtbMetaData.resourceType, showVideoApplicableService),
                BaseGodModeAvailable()
            ),
            ApiCreateDateModelPart(),
            ApiCustomBkDataModelPart(apiRtbMetaData.resourceType),
            ApiDesignTemplatesModelPart(),
            ApiDspBlocksWithSiteVersionModelPart(apiRtbMetaData.resourceType,
                mediaBlockService, RtbBlock::getSiteVersion),
            ApiRtbDspsModelPart(apiRtbMetaData.resourceType, dspService, rtbReachablePageService),
            ApiGeoModelPart(apiRtbMetaData.resourceType, objectMapper),
            ApiTagsModelPart<RtbBlock>(
                apiRtbMetaData.resourceType,
                tagService,
                BaseGodModeAvailable()
            ),
            ApiCustomBkOptionsModelPart<RtbBlock>(
                apiRtbMetaData.resourceType,
                customBkOptionsTypedRepository, BaseGodModeAvailable()
            ),
            ApiPCodeBlockModelPart(),
            ApiReadonlyModelPart<RtbBlock>(
                apiRtbMetaData.resourceType,
                BaseGodModeAvailable()
            ),
            ApiOnlyPortalTrustedBannersModelPart<RtbBlock>(
                apiRtbMetaData.resourceType,
                BaseGodModeAvailable()
            ),
            ApiPiCategoriesModelPart(apiRtbMetaData.resourceType),
            ApiRtbHorizontalAlignModelPart(
                apiRtbMetaData.resourceType
            ),
            ApiRtbBlindModelPart(
                apiRtbMetaData.resourceType
            ),
            ApiRtbSiteVersionModelPart(
                apiRtbMetaData.resourceType, messageSource,
                siteVersionAvailabilityService, rtbReachablePageService
            ),
            ApiRtbStrategyModelPart(
                apiRtbMetaData.resourceType,
                BaseShowVideoAvailable(apiRtbMetaData.resourceType, showVideoApplicableService),
                BaseGodModeAvailable(),
                strategyDefaultsFieldsService,
                showVideoApplicableService
            ),
            ApiDspModeModelPart<RtbBlock>(apiRtbMetaData.resourceType, BaseGodModeAvailable()),
            ApiMultistateFieldsModelPart(multistateCrnkFilterValueParser),
            ApiFieldsDependsModelPart(FIELDS_DEPENDS),
            ApiRequireFieldsModelPart(REQUIRED_FIELDS),
            ApiActionsModelPart(
                blockActionsAuthorizationService.allRequiredProperties,
                blockActionsAuthorizationService,
                rtbBlockMultistateGraph,
                multistateService
            )
        )

        val apiFieldsAvailableRules = ConfigurationUtils.configureAvailableFields(
            modelParts = modelParts,
            functionComposite = functionComposite,
            authenticationFacade = authenticationFacade,
        )

        val apiFieldsEditableRules = ConfigurationUtils.configureEditableFields(
            modelParts = modelParts,
            functionComposite = functionComposite,
            authenticationFacade = authenticationFacade,
            actionsAuthorizationService = blockActionsAuthorizationService,
            editableFieldsService = editableFieldsService
        )

        return ApiRtbModel(
            apiRtbMetaData, modelParts, rtbBlockPolicy,
            apiFieldsAvailableRules, apiFieldsEditableRules
        )
    }

    companion object {
        private val FIELDS_DEPENDS = DependsHolder(
            mapOf(
                BlockCrnkJsonFieldAliases.ID to listOf(BlockCrnkJsonFieldAliases.STRATEGY),
                BlockCrnkJsonFieldAliases.PAGE_ID to listOf(
                    BlockCrnkJsonFieldAliases.AVAILABLE_DESIGN_TEMPLATE_TYPES,
                    BlockCrnkJsonFieldAliases.DSPS, BlockCrnkJsonFieldAliases.SITE_VERSION,
                    BlockCrnkJsonFieldAliases.CURRENT_CURRENCY
                ),
                BlockCrnkJsonFieldAliases.SHOW_VIDEO to listOf(
                    BlockCrnkJsonFieldAliases.DSPS,
                    BlockCrnkJsonFieldAliases.AVAILABLE_DESIGN_TEMPLATE_TYPES
                ),
                BlockCrnkJsonFieldAliases.SITE_VERSION to listOf(
                    BlockCrnkJsonFieldAliases.AVAILABLE_DESIGN_TEMPLATE_TYPES, BlockCrnkJsonFieldAliases.DSP_BLOCKS,
                    BlockCrnkJsonFieldAliases.SHOW_VIDEO
                )
            ),
            mapOf(
                BlockCrnkJsonFieldAliases.AVAILABLE_DESIGN_TEMPLATE_TYPES to listOf(
                    BlockCrnkJsonFieldAliases.PAGE_ID,
                    BlockCrnkJsonFieldAliases.SITE_VERSION, BlockCrnkJsonFieldAliases.SHOW_VIDEO
                ),
                BlockCrnkJsonFieldAliases.DSP_BLOCKS to listOf(BlockCrnkJsonFieldAliases.SITE_VERSION),
                BlockCrnkJsonFieldAliases.DSPS to listOf(
                    BlockCrnkJsonFieldAliases.PAGE_ID,
                    BlockCrnkJsonFieldAliases.SHOW_VIDEO
                ),
                BlockCrnkJsonFieldAliases.SITE_VERSION to listOf(BlockCrnkJsonFieldAliases.PAGE_ID),
                BlockCrnkJsonFieldAliases.STRATEGY to listOf(BlockCrnkJsonFieldAliases.ID),
                BlockCrnkJsonFieldAliases.SHOW_VIDEO to listOf(BlockCrnkJsonFieldAliases.SITE_VERSION),
                BlockCrnkJsonFieldAliases.CURRENT_CURRENCY to listOf(BlockCrnkJsonFieldAliases.PAGE_ID)
            )
        )
        private val REQUIRED_FIELDS = listOf(BlockCrnkJsonFieldAliases.ALT_WIDTH, BlockCrnkJsonFieldAliases.ALT_HEIGHT)
    }
}

