package ru.yandex.partner.jsonapi.models.block.rtb.external;

import java.util.List;
import java.util.Map;

import ru.yandex.partner.core.entity.block.filter.BlockFilters;
import ru.yandex.partner.core.entity.block.model.RtbBlock;
import ru.yandex.partner.core.filter.meta.MetaFilter;
import ru.yandex.partner.jsonapi.crnk.fields.ApiFieldsAccessRulesService;
import ru.yandex.partner.jsonapi.crnk.fields.EditableData;
import ru.yandex.partner.jsonapi.models.AbstractApiModel;
import ru.yandex.partner.jsonapi.models.ApiModelPart;
import ru.yandex.partner.jsonapi.models.ApiResourceType;
import ru.yandex.partner.jsonapi.models.block.relationships.PageOneApiRelationship;
import ru.yandex.partner.jsonapi.models.relationships.ApiRelationship;
import ru.yandex.partner.libs.authorization.policy.base.Policy;

public class ApiRtbModel extends AbstractApiModel<RtbBlock> {
    private final Policy<RtbBlock> policy;
    private final List<ApiRelationship<RtbBlock>> relationships;

    public ApiRtbModel(ApiRtbMetaData apiRtbMetaData, List<ApiModelPart<RtbBlock>> parts, Policy<RtbBlock> policy,
                       ApiFieldsAccessRulesService<RtbBlock> rtbApiFieldsAvailableRules,
                       ApiFieldsAccessRulesService<EditableData<RtbBlock>> rtbApiFieldsEditableRules) {
        super(apiRtbMetaData, parts, rtbApiFieldsAvailableRules, rtbApiFieldsEditableRules);
        this.policy = policy;
        this.relationships = List.of(
                new PageOneApiRelationship<>(ApiResourceType.CONTEXT_ON_SITE_CAMPAIGN)
        );
    }

    @Override
    public MetaFilter<? super RtbBlock, Long> getIdFilter() {
        return BlockFilters.ID;
    }

    @Override
    public RtbBlock createNewInstance() {
        return new RtbBlock();
    }

    @Override
    public Policy<RtbBlock> getPolicy() {
        return policy;
    }

    @Override
    public Map<String, Map<String, String>> getRelationshipsLinks() {
        return Map.of(
                "context_on_site_campaign", Map.of(
                        "self", "relationships/context_on_site_campaign",
                        "related", "context_on_site_campaign"),

                "pages", Map.of(
                        "self", "relationships/pages",
                        "related", "pages")
        );
    }

    @Override
    public List<ApiRelationship<RtbBlock>> getApiRelationships() {
        return relationships;
    }
}
