package ru.yandex.partner.jsonapi.models.block.rtb.external;

import ru.yandex.partner.core.entity.block.model.RtbBlock;
import ru.yandex.partner.core.entity.block.type.commonshowvideo.ShowVideoApplicableService;
import ru.yandex.partner.core.entity.strategy.StrategyDefaultsFieldsService;
import ru.yandex.partner.jsonapi.crnk.fields.ApiFieldsAccessRulesFunction;
import ru.yandex.partner.jsonapi.models.block.parts.ApiContextRtbStrategyModelPart;
import ru.yandex.partner.jsonapi.models.block.parts.GodModeAvailable;
import ru.yandex.partner.jsonapi.models.block.parts.ShowVideoAvailable;

public class ApiRtbStrategyModelPart extends ApiContextRtbStrategyModelPart<RtbBlock> {

    public ApiRtbStrategyModelPart(String modelName,
                                   ShowVideoAvailable<RtbBlock> showVideoAvailableDelegate,
                                   GodModeAvailable<RtbBlock> godModeAvailableDelegate,
                                   StrategyDefaultsFieldsService strategyDefaultsFieldsService,
                                   ShowVideoApplicableService showVideoApplicableService) {
        super(modelName, showVideoAvailableDelegate, godModeAvailableDelegate, strategyDefaultsFieldsService,
                showVideoApplicableService);
    }

    @Override
    protected String extractSiteVersion(RtbBlock block) {
        return block.getSiteVersion();
    }

    @Override
    protected ApiFieldsAccessRulesFunction<RtbBlock> videoActiveAvailableFunction() {
        return new ApiFieldsAccessRulesFunction<>(
                (userAuthentication, rtbBlock) -> Boolean.TRUE.equals(rtbBlock.getShowVideo()),
                RtbBlock.SHOW_VIDEO);
    }
}
