package ru.yandex.partner.jsonapi.models.block.rtb.external;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import ru.yandex.partner.core.entity.block.model.RtbBlock;
import ru.yandex.partner.core.entity.page.model.ContextPage;
import ru.yandex.partner.jsonapi.crnk.page.ExternalPageReachabilityService;
import ru.yandex.partner.jsonapi.models.ApiModel;
import ru.yandex.partner.jsonapi.models.block.AuthBlockContainerConfigurer;
import ru.yandex.partner.libs.auth.facade.AuthenticationFacade;

@Component
public class RtbAuthBlockContainerConfigurer extends AuthBlockContainerConfigurer<RtbBlock, ContextPage> {
    @Autowired
    public RtbAuthBlockContainerConfigurer(AuthenticationFacade authenticationFacade,
                                           ExternalPageReachabilityService pageReachabilityService,
                                           ApiModel<RtbBlock> blockApiModel,
                                           ApiModel<ContextPage> pageApiModel) {
        super(authenticationFacade, pageReachabilityService, blockApiModel, pageApiModel);
    }

    @Override
    public Class getModelClass() {
        return RtbBlock.class;
    }
}
