package ru.yandex.partner.jsonapi.models.block.rtb.external;

import java.util.Optional;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import ru.yandex.partner.core.entity.block.model.RtbBlock;
import ru.yandex.partner.core.entity.page.model.ContextPage;
import ru.yandex.partner.core.entity.page.service.ReachablePageService;
import ru.yandex.partner.core.entity.user.model.User;
import ru.yandex.partner.core.filter.CoreFilterNode;
import ru.yandex.partner.jsonapi.crnk.exceptions.CrnkResponseStatusException;
import ru.yandex.partner.jsonapi.models.block.BlockDesignTemplateTypesDefaultsService;
import ru.yandex.partner.libs.exceptions.HttpErrorStatusEnum;

@Service
public class RtbBlockDesignTemplateTypesDefaultsService extends BlockDesignTemplateTypesDefaultsService<RtbBlock> {

    private final ReachablePageService<RtbBlock> reachablePageService;

    @Autowired
    public RtbBlockDesignTemplateTypesDefaultsService(
            ReachablePageService<RtbBlock> reachablePageService) {
        super();
        this.reachablePageService = reachablePageService;
    }

    @Override
    protected String getSiteVersion(RtbBlock block) {
        return block.getSiteVersion();
    }

    @Override
    protected Boolean getShowVideo(RtbBlock block) {
        return block.getShowVideo();
    }

    @Override
    protected User getOwner(RtbBlock block) {
        Long pageId = Optional.ofNullable(block.getPageId())
                .orElseThrow(() -> new CrnkResponseStatusException(HttpErrorStatusEnum.ERROR__PARAMS));
        var filter = CoreFilterNode.eq(reachablePageService.getPageIdMetaFilter(), pageId);
        var campaign = reachablePageService
                .getReachablePages(filter, ContextPage.class).stream()
                .findFirst()
                .orElseThrow(() -> new CrnkResponseStatusException(HttpErrorStatusEnum.ERROR__NOT_FOUND));

        return campaign.getOwner();
    }
}
