
package ru.yandex.partner.jsonapi.models.block.rtb.internal;

import java.util.Map;
import java.util.function.Function;
import java.util.function.Supplier;

import ru.yandex.partner.core.block.BlockUniqueIdConverter;
import ru.yandex.partner.core.entity.block.model.InternalRtbBlock;
import ru.yandex.partner.core.entity.page.model.InternalContextPage;
import ru.yandex.partner.core.entity.page.service.ReachablePageService;
import ru.yandex.partner.core.filter.CoreFilterNode;
import ru.yandex.partner.jsonapi.crnk.CrnkModelFilters;
import ru.yandex.partner.jsonapi.crnk.authorization.request.RequestAuthorizationService;
import ru.yandex.partner.jsonapi.crnk.filter.parser.CrnkFilterParser;
import ru.yandex.partner.jsonapi.crnk.page.PageCrnkJsonFieldAliases;
import ru.yandex.partner.jsonapi.models.block.parts.ApiBaseBlockModelPart;
import ru.yandex.partner.libs.authorization.policy.base.Policy;

public class ApiInternalRtbBaseBlockModelPart extends ApiBaseBlockModelPart<InternalRtbBlock, InternalContextPage> {


    @SuppressWarnings("checkstyle:parameternumber")
    public ApiInternalRtbBaseBlockModelPart(CrnkFilterParser crnkFilterParser,
                                            CrnkModelFilters<InternalContextPage> pageCrnkModelFilters,
                                            RequestAuthorizationService requestAuthorizationService,
                                            Policy<InternalContextPage> pagePolicy,
                                            BlockUniqueIdConverter.Prefixes prefix,
                                            ReachablePageService<InternalRtbBlock> reachablePageService,
                                            Supplier<CoreFilterNode<InternalContextPage>> authPageFilterProvider,
                                            Class<InternalContextPage> pageClass, boolean needPageIdFilter) {
        super(crnkFilterParser, pageCrnkModelFilters, requestAuthorizationService, pagePolicy, prefix,
                reachablePageService, authPageFilterProvider, pageClass, needPageIdFilter);
    }

    @Override
    protected Function<InternalContextPage, Map<String, Object>> pageMapper() {
        return page -> Map.of(
                // TODO: поправить объединения пейджей
                PageCrnkJsonFieldAliases.CAPTION, page.getDomain(), // <--
                PageCrnkJsonFieldAliases.DOMAIN, page.getDomain(),
                PageCrnkJsonFieldAliases.PAGE_ID, page.getId(),
                PageCrnkJsonFieldAliases.ID, page.getId()
        );
    }
}
