package ru.yandex.partner.jsonapi.models.block.rtb.internal;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;

import com.fasterxml.jackson.databind.ObjectMapper;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.MessageSource;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

import ru.yandex.direct.validation.presentation.DefectPresentationRegistry;
import ru.yandex.partner.core.action.ActionPerformer;
import ru.yandex.partner.core.block.BlockUniqueIdConverter;
import ru.yandex.partner.core.entity.block.model.BaseBlock;
import ru.yandex.partner.core.entity.block.model.BlockWithMultistate;
import ru.yandex.partner.core.entity.block.model.InternalRtbBlock;
import ru.yandex.partner.core.entity.block.multistate.InternalRtbBlockMultistateGraph;
import ru.yandex.partner.core.entity.block.multistate.RtbBlockMultistateExpressionParser;
import ru.yandex.partner.core.entity.block.service.BlockAddService;
import ru.yandex.partner.core.entity.block.service.BlockService;
import ru.yandex.partner.core.entity.block.type.commonshowvideo.ShowVideoApplicableService;
import ru.yandex.partner.core.entity.block.type.dspblocks.MediaBlockService;
import ru.yandex.partner.core.entity.block.type.siteversionandcontextpage.SiteVersionAvailabilityService;
import ru.yandex.partner.core.entity.block.type.tags.TagService;
import ru.yandex.partner.core.entity.common.editablefields.EditableFieldsService;
import ru.yandex.partner.core.entity.custombkoptions.CustomBkOptionsTypedRepository;
import ru.yandex.partner.core.entity.dsp.service.DspService;
import ru.yandex.partner.core.entity.page.model.InternalContextPage;
import ru.yandex.partner.core.entity.page.service.InternalRtbReachablePageService;
import ru.yandex.partner.core.entity.strategy.StrategyDefaultsFieldsService;
import ru.yandex.partner.jsonapi.crnk.authorization.actions.ActionsAuthorizationService;
import ru.yandex.partner.jsonapi.crnk.authorization.request.RequestAuthorizationService;
import ru.yandex.partner.jsonapi.crnk.block.BlockCrnkJsonFieldAliases;
import ru.yandex.partner.jsonapi.crnk.block.rtb.internal.InternalRtbBlockApiFieldsService;
import ru.yandex.partner.jsonapi.crnk.fields.ApiFieldsAccessRulesService;
import ru.yandex.partner.jsonapi.crnk.fields.EditableData;
import ru.yandex.partner.jsonapi.crnk.filter.parser.CrnkFilterParser;
import ru.yandex.partner.jsonapi.crnk.filter.parser.values.MultistateCrnkFilterValueParser;
import ru.yandex.partner.jsonapi.crnk.multistate.MultistateService;
import ru.yandex.partner.jsonapi.crnk.page.InternalPageCrnkModelFilters;
import ru.yandex.partner.jsonapi.crnk.page.InternalPageReachabilityService;
import ru.yandex.partner.jsonapi.crnk.page.PageCrnkMapper;
import ru.yandex.partner.jsonapi.models.AccessFunctionComposite;
import ru.yandex.partner.jsonapi.models.ApiModel;
import ru.yandex.partner.jsonapi.models.ApiModelPart;
import ru.yandex.partner.jsonapi.models.DependsHolder;
import ru.yandex.partner.jsonapi.models.block.ApiBlockService;
import ru.yandex.partner.jsonapi.models.block.BlockRightNames;
import ru.yandex.partner.jsonapi.models.block.actions.BlockActionService;
import ru.yandex.partner.jsonapi.models.block.parts.ApiAdfoxBlockModelPart;
import ru.yandex.partner.jsonapi.models.block.parts.ApiAlternativeCodeModelPart;
import ru.yandex.partner.jsonapi.models.block.parts.ApiBrandsModelPart;
import ru.yandex.partner.jsonapi.models.block.parts.ApiCommonShowVideoWithDelegateModelPart;
import ru.yandex.partner.jsonapi.models.block.parts.ApiCreateDateModelPart;
import ru.yandex.partner.jsonapi.models.block.parts.ApiCustomBkDataModelPart;
import ru.yandex.partner.jsonapi.models.block.parts.ApiCustomBkOptionsModelPart;
import ru.yandex.partner.jsonapi.models.block.parts.ApiDesignTemplatesModelPart;
import ru.yandex.partner.jsonapi.models.block.parts.ApiDspBlocksWithSiteVersionModelPart;
import ru.yandex.partner.jsonapi.models.block.parts.ApiDspModeModelPart;
import ru.yandex.partner.jsonapi.models.block.parts.ApiGeoWithRightModelPart;
import ru.yandex.partner.jsonapi.models.block.parts.ApiInternalCampaignModelPart;
import ru.yandex.partner.jsonapi.models.block.parts.ApiInternalRtbBlindModelPart;
import ru.yandex.partner.jsonapi.models.block.parts.ApiMultistateFieldsModelPart;
import ru.yandex.partner.jsonapi.models.block.parts.ApiOnlyPortalTrustedBannersModelPart;
import ru.yandex.partner.jsonapi.models.block.parts.ApiPCodeBlockModelPart;
import ru.yandex.partner.jsonapi.models.block.parts.ApiPiCategoriesModelPart;
import ru.yandex.partner.jsonapi.models.block.parts.ApiTagsModelPart;
import ru.yandex.partner.jsonapi.models.block.parts.BaseGodModeAvailable;
import ru.yandex.partner.jsonapi.models.block.parts.BaseShowVideoAvailable;
import ru.yandex.partner.jsonapi.models.block.rtb.ApiRtbCommonModelPart;
import ru.yandex.partner.jsonapi.models.common.ApiActionsModelPart;
import ru.yandex.partner.jsonapi.models.common.ApiFieldsDependsModelPart;
import ru.yandex.partner.jsonapi.models.common.ApiMultistateModelPart;
import ru.yandex.partner.jsonapi.models.page.internal.ApiInternalContextPageMetaData;
import ru.yandex.partner.jsonapi.utils.ConfigurationUtils;
import ru.yandex.partner.libs.authorization.policy.base.Policy;
import ru.yandex.partner.libs.i18n.TranslatableError;

@Configuration
public class ApiInternalRtbConfiguration {
    public static final DependsHolder DEPENDS_HOLDER = new DependsHolder(
            Map.of(
                    BlockCrnkJsonFieldAliases.PAGE_ID,
                    List.of(BlockCrnkJsonFieldAliases.AVAILABLE_DESIGN_TEMPLATE_TYPES,
                            BlockCrnkJsonFieldAliases.DSPS,
                            BlockCrnkJsonFieldAliases.SITE_VERSION),

                    BlockCrnkJsonFieldAliases.SHOW_VIDEO,
                    List.of(BlockCrnkJsonFieldAliases.DSPS, BlockCrnkJsonFieldAliases.AVAILABLE_DESIGN_TEMPLATE_TYPES),

                    BlockCrnkJsonFieldAliases.SITE_VERSION,
                    List.of(BlockCrnkJsonFieldAliases.AVAILABLE_DESIGN_TEMPLATE_TYPES,
                            BlockCrnkJsonFieldAliases.DSP_BLOCKS,
                            BlockCrnkJsonFieldAliases.SHOW_VIDEO),

                    BlockCrnkJsonFieldAliases.ID,
                    List.of(BlockCrnkJsonFieldAliases.STRATEGY)
            ),
            Map.of(
                    BlockCrnkJsonFieldAliases.AVAILABLE_DESIGN_TEMPLATE_TYPES,
                    List.of(BlockCrnkJsonFieldAliases.PAGE_ID,
                            BlockCrnkJsonFieldAliases.SITE_VERSION,
                            BlockCrnkJsonFieldAliases.SHOW_VIDEO),

                    BlockCrnkJsonFieldAliases.DSP_BLOCKS,
                    List.of(BlockCrnkJsonFieldAliases.SITE_VERSION),

                    BlockCrnkJsonFieldAliases.DSPS,
                    List.of(BlockCrnkJsonFieldAliases.PAGE_ID, BlockCrnkJsonFieldAliases.SHOW_VIDEO),

                    BlockCrnkJsonFieldAliases.SITE_VERSION,
                    List.of(BlockCrnkJsonFieldAliases.PAGE_ID),

                    BlockCrnkJsonFieldAliases.STRATEGY,
                    List.of(BlockCrnkJsonFieldAliases.ID),

                    BlockCrnkJsonFieldAliases.SHOW_VIDEO,
                    List.of(BlockCrnkJsonFieldAliases.SITE_VERSION)
            )
    );

    @Bean
    @SuppressWarnings("checkstyle:parameternumber")
    public ApiBlockService<InternalRtbBlock> apiBlockService(
            ActionPerformer actionPerformer,
            DefectPresentationRegistry<TranslatableError> defectPresentationRegistry,
            RequestAuthorizationService requestAuthorizationService,
            BlockService blockService,
            BlockAddService<BlockWithMultistate> blockAddService,
            InternalRtbBlockApiFieldsService internalRtbBlockApiFieldsService,
            ApiInternalRtbModel apiInternalRtbModel,
            ActionsAuthorizationService<InternalRtbBlock> actionsAuthorizationService,
            InternalRtbAuthBlockContainerConfigurer authBlockContainerConfigurer,
            BlockActionService<InternalRtbBlock> blockActionService,
            ApiInternalContextPageMetaData pageMetaData
    ) {

        return new ApiBlockService<>(
                actionPerformer,
                defectPresentationRegistry,
                requestAuthorizationService,
                actionsAuthorizationService,
                internalRtbBlockApiFieldsService,
                apiInternalRtbModel,
                blockService,
                blockAddService,
                blockActionService,
                authBlockContainerConfigurer,
                pageMetaData);
    }


    @Bean
    @SuppressWarnings("checkstyle:parameternumber")
    public ApiInternalRtbModel apiInternalRtbModel(
            BlockService blockService,
            ApiInternalRtbMetaData apiInternalRtbMetaData,
            CrnkFilterParser crnkFilterParser,
            InternalPageCrnkModelFilters internalPageCrnkModelFilters,
            RequestAuthorizationService requestAuthorizationService,
            Policy<InternalContextPage> policy,
            Policy<InternalRtbBlock> internalRtbBlockPolicy,
            InternalRtbReachablePageService reachablePageService,
            InternalPageReachabilityService pageReachabilityService,
            ApiModel<InternalContextPage> pageApiModel,
            EditableFieldsService<BaseBlock> editableFieldsService,
            AccessFunctionComposite<InternalRtbBlock> blockAccessFunctionComposite,
            ActionsAuthorizationService<InternalRtbBlock> actionsAuthorizationService,
            PageCrnkMapper pageCrnkMapper,
            InternalRtbBlockMultistateGraph multistateGraph,
            MultistateService multistateService,
            TagService tagService,
            CustomBkOptionsTypedRepository customBkOptionsTypedRepository,
            ShowVideoApplicableService showVideoApplicableService,
            MediaBlockService mediaBlockService,
            ObjectMapper objectMapper,
            @Value("${partner.block.need-page-id-filter}") boolean needPageIdFilter,
            InternalRtbReachablePageService internalRtbReachablePageService,
            SiteVersionAvailabilityService siteVersionAvailabilityService,
            MessageSource messageSource,
            DspService dspService,
            StrategyDefaultsFieldsService strategyDefaultsFieldsService,
            RtbBlockMultistateExpressionParser rtbBlockMultistateExpressionParser,
            InternalRtbFieldsCompatibilityService internalRtbFieldsCompatibilityService
    ) {
        var multistateCrnkFilterValueParser = new MultistateCrnkFilterValueParser<>(
                multistateGraph,
                rtbBlockMultistateExpressionParser
        );
        var authenticationFacade = requestAuthorizationService.getAuthenticationFacade();
        List<ApiModelPart<InternalRtbBlock>> modelParts = new ArrayList<>(List.of(
                new ApiInternalRtbBaseBlockModelPart(
                        crnkFilterParser,
                        internalPageCrnkModelFilters,
                        requestAuthorizationService,
                        policy,
                        BlockUniqueIdConverter.Prefixes.INTERNAL_CONTEXT_ON_SITE_RTB_PREFIX,
                        reachablePageService,
                        () -> pageReachabilityService
                                .reachablePagesFilter(pageApiModel)
                                .and(pageReachabilityService.getNotProtectedFilter()),
                        InternalContextPage.class,
                        needPageIdFilter
                ),
                new ApiRtbCommonModelPart<>(apiInternalRtbMetaData.getResourceType(),
                        BlockRightNames.VIEW_FIELD__COMMENT),
                new ApiFieldsDependsModelPart<>(DEPENDS_HOLDER),
                new ApiInternalCampaignModelPart<>(pageApiModel, pageCrnkMapper, authenticationFacade),
                new ApiActionsModelPart<>(
                        actionsAuthorizationService.getAllRequiredProperties(),
                        actionsAuthorizationService,
                        multistateGraph,
                        multistateService
                ),
                new ApiAdfoxBlockModelPart<>(),
                new ApiTagsModelPart<>(apiInternalRtbMetaData.getResourceType(), tagService,
                        new BaseGodModeAvailable<>()),
                new ApiOnlyPortalTrustedBannersModelPart<>(
                        apiInternalRtbMetaData.getResourceType(),
                        new BaseGodModeAvailable<>()
                ),
                new ApiCustomBkOptionsModelPart<>(apiInternalRtbMetaData.getResourceType(),
                        customBkOptionsTypedRepository, new BaseGodModeAvailable<>()),
                new ApiCreateDateModelPart<>(),
                new ApiCommonShowVideoWithDelegateModelPart<>(
                        apiInternalRtbMetaData.getResourceType(),
                        new BaseShowVideoAvailable<>(apiInternalRtbMetaData.getResourceType(),
                                showVideoApplicableService),
                        new BaseGodModeAvailable<>()),
                new ApiBrandsModelPart<>(),
                new ApiCustomBkDataModelPart<>(apiInternalRtbMetaData.getResourceType()),
                new ApiGeoWithRightModelPart<>(apiInternalRtbMetaData.getResourceType(), objectMapper),
                new ApiAlternativeCodeModelPart<>(),
                new ApiInternalRtbHorizontalAlignModelPart(apiInternalRtbMetaData.getResourceType()),
                new ApiInternalRtbBlindModelPart(apiInternalRtbMetaData.getResourceType()),
                new ApiDspBlocksWithSiteVersionModelPart<>(apiInternalRtbMetaData.getResourceType(),
                        mediaBlockService, InternalRtbBlock::getSiteVersion),
                new ApiInternalRtbSiteVersionModelPart(
                        apiInternalRtbMetaData.getResourceType(), messageSource,
                        siteVersionAvailabilityService, internalRtbReachablePageService),
                new ApiInternalRtbStrategyModelPart(
                        apiInternalRtbMetaData.getResourceType(),
                        new BaseShowVideoAvailable<>(
                                apiInternalRtbMetaData.getResourceType(),
                                showVideoApplicableService
                        ),
                        new BaseGodModeAvailable<>(),
                        strategyDefaultsFieldsService,
                        showVideoApplicableService),
                new ApiDesignTemplatesModelPart<>(),
                new ApiInternalRtbDspsModelPart(
                        apiInternalRtbMetaData.getResourceType(),
                        dspService,
                        reachablePageService
                ),
                new ApiPiCategoriesModelPart<>(apiInternalRtbMetaData.getResourceType()),
                new ApiPCodeBlockModelPart<>(),
                new ApiMultistateFieldsModelPart<>(multistateCrnkFilterValueParser),
                new ApiMultistateModelPart<>(
                        multistateService, InternalRtbBlock.MULTISTATE
                ),
                new ApiDspModeModelPart<>(apiInternalRtbMetaData.getResourceType(), new BaseGodModeAvailable<>())
        ));


        ApiFieldsAccessRulesService<InternalRtbBlock> availableService =
                ConfigurationUtils.INSTANCE.configureAvailableFields(
                        modelParts,
                        blockAccessFunctionComposite,
                        requestAuthorizationService.getAuthenticationFacade(),
                        internalRtbFieldsCompatibilityService
                );

        ApiFieldsAccessRulesService<EditableData<InternalRtbBlock>> editableService =
                ConfigurationUtils.INSTANCE.configureEditableFields(
                        modelParts,
                        blockAccessFunctionComposite,
                        requestAuthorizationService.getAuthenticationFacade(),
                        actionsAuthorizationService,
                        editableFieldsService
                );

        return new ApiInternalRtbModel(
                apiInternalRtbMetaData,
                modelParts,
                internalRtbBlockPolicy,
                availableService,
                editableService
        );
    }
}
