package ru.yandex.partner.jsonapi.models.block.rtb.internal;

import java.util.List;
import java.util.Map;

import ru.yandex.partner.core.entity.block.filter.BlockFilters;
import ru.yandex.partner.core.entity.block.model.InternalRtbBlock;
import ru.yandex.partner.core.filter.meta.MetaFilter;
import ru.yandex.partner.jsonapi.crnk.fields.ApiFieldsAccessRulesService;
import ru.yandex.partner.jsonapi.crnk.fields.EditableData;
import ru.yandex.partner.jsonapi.models.AbstractApiModel;
import ru.yandex.partner.jsonapi.models.ApiModelPart;
import ru.yandex.partner.jsonapi.models.ApiResourceType;
import ru.yandex.partner.jsonapi.models.block.relationships.PageOneApiRelationship;
import ru.yandex.partner.jsonapi.models.relationships.ApiRelationship;
import ru.yandex.partner.libs.authorization.policy.base.Policy;

public class ApiInternalRtbModel extends AbstractApiModel<InternalRtbBlock> {
    private final Policy<InternalRtbBlock> policy;
    private final List<ApiRelationship<InternalRtbBlock>> relationships;

    public ApiInternalRtbModel(ApiInternalRtbMetaData apiInternalRtbMetaData,
                               List<ApiModelPart<InternalRtbBlock>> parts,
                               Policy<InternalRtbBlock> policy,
                               ApiFieldsAccessRulesService<InternalRtbBlock> rtbApiFieldsAvailableRules,
                               ApiFieldsAccessRulesService<EditableData<InternalRtbBlock>> rtbApiFieldsEditableRules) {
        super(apiInternalRtbMetaData, parts, rtbApiFieldsAvailableRules, rtbApiFieldsEditableRules);
        this.policy = policy;
        this.relationships = List.of(
                new PageOneApiRelationship<>(ApiResourceType.INTERNAL_CONTEXT_ON_SITE_CAMPAIGN)
        );
    }

    @Override
    public InternalRtbBlock createNewInstance() {
        return new InternalRtbBlock();
    }

    @Override
    public Policy<InternalRtbBlock> getPolicy() {
        return policy;
    }

    @Override
    public MetaFilter<? super InternalRtbBlock, Long> getIdFilter() {
        return BlockFilters.ID;
    }

    @Override
    public Map<String, Map<String, String>> getRelationshipsLinks() {
        return Map.of(
                "internal_context_on_site_campaign", Map.of(
                        "self", "relationships/internal_context_on_site_campaign",
                        "related", "internal_context_on_site_campaign"),

                "pages", Map.of(
                        "self", "relationships/pages",
                        "related", "pages")
        );
    }

    @Override
    public List<ApiRelationship<InternalRtbBlock>> getApiRelationships() {
        return relationships;
    }
}
