package ru.yandex.partner.jsonapi.models.block.rtb.internal;

import ru.yandex.partner.core.entity.block.model.InternalRtbBlock;
import ru.yandex.partner.core.entity.block.type.commonshowvideo.ShowVideoApplicableService;
import ru.yandex.partner.core.entity.strategy.StrategyDefaultsFieldsService;
import ru.yandex.partner.jsonapi.crnk.fields.ApiFieldsAccessRulesFunction;
import ru.yandex.partner.jsonapi.models.block.parts.ApiContextRtbStrategyModelPart;
import ru.yandex.partner.jsonapi.models.block.parts.BaseGodModeAvailable;
import ru.yandex.partner.jsonapi.models.block.parts.BaseShowVideoAvailable;

public class ApiInternalRtbStrategyModelPart extends ApiContextRtbStrategyModelPart<InternalRtbBlock> {

    public ApiInternalRtbStrategyModelPart(String modelName,
                                           BaseShowVideoAvailable<InternalRtbBlock> showVideoAvailable,
                                           BaseGodModeAvailable<InternalRtbBlock> blockBaseGodModeAvailable,
                                           StrategyDefaultsFieldsService strategyDefaultsFieldsService,
                                           ShowVideoApplicableService showVideoApplicableService) {
        super(modelName, showVideoAvailable, blockBaseGodModeAvailable, strategyDefaultsFieldsService,
                showVideoApplicableService);
    }

    @Override
    protected ApiFieldsAccessRulesFunction<InternalRtbBlock> videoActiveAvailableFunction() {
        return new ApiFieldsAccessRulesFunction<>(
                (userAuthentication, rtbBlock) -> Boolean.TRUE.equals(rtbBlock.getShowVideo()),
                InternalRtbBlock.SHOW_VIDEO);
    }

    @Override
    protected String extractSiteVersion(InternalRtbBlock block) {
        return block.getSiteVersion();
    }
}
