package ru.yandex.partner.jsonapi.models.block.rtb.internal;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import ru.yandex.partner.core.entity.block.model.InternalRtbBlock;
import ru.yandex.partner.core.entity.page.model.InternalContextPage;
import ru.yandex.partner.jsonapi.crnk.page.InternalPageReachabilityService;
import ru.yandex.partner.jsonapi.models.ApiModel;
import ru.yandex.partner.jsonapi.models.block.AuthBlockContainerConfigurer;
import ru.yandex.partner.libs.auth.facade.AuthenticationFacade;

@Component
public class InternalRtbAuthBlockContainerConfigurer
        extends AuthBlockContainerConfigurer<InternalRtbBlock, InternalContextPage> {

    @Autowired
    public InternalRtbAuthBlockContainerConfigurer(AuthenticationFacade authenticationFacade,
                                                   InternalPageReachabilityService pageReachabilityService,
                                                   ApiModel<InternalRtbBlock> blockApiModel,
                                                   ApiModel<InternalContextPage> pageApiModel) {
        super(authenticationFacade, pageReachabilityService, blockApiModel, pageApiModel);
    }

    @Override
    public Class getModelClass() {
        return InternalRtbBlock.class;
    }
}
